/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import com.google.gson.Gson;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import org.hibernate.search.backend.elasticsearch.logging.impl.MappingLog;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchIndexFieldTypeFactory;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchNativeIndexFieldTypeMappingStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchBigDecimalIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchBigIntegerIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchBooleanIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchByteIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchByteVectorFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchDoubleIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchFloatIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchFloatVectorFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchGeoPointIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchInstantIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIntegerIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchLocalDateIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchLocalDateTimeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchLocalTimeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchLongIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchMonthDayIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchNativeIndexFieldTypeMappingStepImpl;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchOffsetDateTimeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchOffsetTimeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchShortIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchStringIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchYearIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchYearMonthIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchZonedDateTimeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.format.impl.ElasticsearchDefaultFieldFormatProvider;
import org.hibernate.search.backend.elasticsearch.types.mapping.impl.ElasticsearchVectorFieldTypeMappingContributor;
import org.hibernate.search.engine.backend.mapping.spi.BackendMapperContext;
import org.hibernate.search.engine.backend.reporting.spi.BackendMappingHints;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.VectorFieldTypeOptionsStep;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchIndexFieldTypeFactoryImpl
implements ElasticsearchIndexFieldTypeFactory,
ElasticsearchIndexFieldTypeBuildContext {
    private final EventContext eventContext;
    private final BackendMapperContext backendMapperContext;
    private final Gson userFacingGson;
    private final ElasticsearchDefaultFieldFormatProvider defaultFieldFormatProvider;
    private final IndexFieldTypeDefaultsProvider typeDefaultsProvider;
    private final ElasticsearchVectorFieldTypeMappingContributor vectorFieldTypeMappingContributor;

    public ElasticsearchIndexFieldTypeFactoryImpl(EventContext eventContext, BackendMapperContext backendMapperContext, Gson userFacingGson, ElasticsearchDefaultFieldFormatProvider defaultFieldFormatProvider, IndexFieldTypeDefaultsProvider typeDefaultsProvider, ElasticsearchVectorFieldTypeMappingContributor vectorFieldTypeMappingContributor) {
        this.eventContext = eventContext;
        this.backendMapperContext = backendMapperContext;
        this.userFacingGson = userFacingGson;
        this.defaultFieldFormatProvider = defaultFieldFormatProvider;
        this.typeDefaultsProvider = typeDefaultsProvider;
        this.vectorFieldTypeMappingContributor = vectorFieldTypeMappingContributor;
    }

    public <F> StandardIndexFieldTypeOptionsStep<?, F> as(Class<F> valueType) {
        if (String.class.equals(valueType)) {
            return this.asString();
        }
        if (Integer.class.equals(valueType)) {
            return this.asInteger();
        }
        if (Long.class.equals(valueType)) {
            return this.asLong();
        }
        if (Boolean.class.equals(valueType)) {
            return this.asBoolean();
        }
        if (Byte.class.equals(valueType)) {
            return this.asByte();
        }
        if (Short.class.equals(valueType)) {
            return this.asShort();
        }
        if (Float.class.equals(valueType)) {
            return this.asFloat();
        }
        if (Double.class.equals(valueType)) {
            return this.asDouble();
        }
        if (LocalDate.class.equals(valueType)) {
            return this.asLocalDate();
        }
        if (LocalDateTime.class.equals(valueType)) {
            return this.asLocalDateTime();
        }
        if (LocalTime.class.equals(valueType)) {
            return this.asLocalTime();
        }
        if (Instant.class.equals(valueType)) {
            return this.asInstant();
        }
        if (ZonedDateTime.class.equals(valueType)) {
            return this.asZonedDateTime();
        }
        if (Year.class.equals(valueType)) {
            return this.asYear();
        }
        if (YearMonth.class.equals(valueType)) {
            return this.asYearMonth();
        }
        if (MonthDay.class.equals(valueType)) {
            return this.asMonthDay();
        }
        if (OffsetDateTime.class.equals(valueType)) {
            return this.asOffsetDateTime();
        }
        if (OffsetTime.class.equals(valueType)) {
            return this.asOffsetTime();
        }
        if (GeoPoint.class.equals(valueType)) {
            return this.asGeoPoint();
        }
        if (BigDecimal.class.equals(valueType)) {
            return this.asBigDecimal();
        }
        if (BigInteger.class.equals(valueType)) {
            return this.asBigInteger();
        }
        throw MappingLog.INSTANCE.cannotGuessFieldType(valueType, this.getEventContext());
    }

    public StringIndexFieldTypeOptionsStep<?> asString() {
        return new ElasticsearchStringIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Integer> asInteger() {
        return new ElasticsearchIntegerIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Long> asLong() {
        return new ElasticsearchLongIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Boolean> asBoolean() {
        return new ElasticsearchBooleanIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Byte> asByte() {
        return new ElasticsearchByteIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Short> asShort() {
        return new ElasticsearchShortIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Float> asFloat() {
        return new ElasticsearchFloatIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Double> asDouble() {
        return new ElasticsearchDoubleIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, LocalDate> asLocalDate() {
        return new ElasticsearchLocalDateIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, LocalDateTime> asLocalDateTime() {
        return new ElasticsearchLocalDateTimeIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, LocalTime> asLocalTime() {
        return new ElasticsearchLocalTimeIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Instant> asInstant() {
        return new ElasticsearchInstantIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, ZonedDateTime> asZonedDateTime() {
        return new ElasticsearchZonedDateTimeIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Year> asYear() {
        return new ElasticsearchYearIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, YearMonth> asYearMonth() {
        return new ElasticsearchYearMonthIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, MonthDay> asMonthDay() {
        return new ElasticsearchMonthDayIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, OffsetDateTime> asOffsetDateTime() {
        return new ElasticsearchOffsetDateTimeIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, OffsetTime> asOffsetTime() {
        return new ElasticsearchOffsetTimeIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, GeoPoint> asGeoPoint() {
        return new ElasticsearchGeoPointIndexFieldTypeOptionsStep(this);
    }

    public ScaledNumberIndexFieldTypeOptionsStep<?, BigDecimal> asBigDecimal() {
        return new ElasticsearchBigDecimalIndexFieldTypeOptionsStep((ElasticsearchIndexFieldTypeBuildContext)this, this.typeDefaultsProvider);
    }

    public ScaledNumberIndexFieldTypeOptionsStep<?, BigInteger> asBigInteger() {
        return new ElasticsearchBigIntegerIndexFieldTypeOptionsStep((ElasticsearchIndexFieldTypeBuildContext)this, this.typeDefaultsProvider);
    }

    public <F> VectorFieldTypeOptionsStep<?, F> asVector(Class<F> valueType) {
        if (byte[].class.equals(valueType)) {
            return this.asByteVector();
        }
        if (float[].class.equals(valueType)) {
            return this.asFloatVector();
        }
        throw MappingLog.INSTANCE.cannotGuessVectorFieldType(valueType, this.getEventContext());
    }

    public VectorFieldTypeOptionsStep<?, byte[]> asByteVector() {
        return new ElasticsearchByteVectorFieldTypeOptionsStep(this, this.vectorFieldTypeMappingContributor);
    }

    public VectorFieldTypeOptionsStep<?, float[]> asFloatVector() {
        return new ElasticsearchFloatVectorFieldTypeOptionsStep(this, this.vectorFieldTypeMappingContributor);
    }

    @Override
    public ElasticsearchNativeIndexFieldTypeMappingStep asNative() {
        return new ElasticsearchNativeIndexFieldTypeMappingStepImpl(this);
    }

    @Override
    public EventContext getEventContext() {
        return this.eventContext;
    }

    @Override
    public Gson getUserFacingGson() {
        return this.userFacingGson;
    }

    @Override
    public ElasticsearchDefaultFieldFormatProvider getDefaultFieldFormatProvider() {
        return this.defaultFieldFormatProvider;
    }

    @Override
    public BackendMappingHints hints() {
        return this.backendMapperContext.hints();
    }
}

