/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchNestableAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.search.aggregation.spi.SearchFilterableAggregationBuilder;

public class ElasticsearchMetricLongAggregation
extends AbstractElasticsearchNestableAggregation<Long> {
    private static final JsonAccessor<JsonObject> COUNT_PROPERTY_ACCESSOR = JsonAccessor.root().property("value_count").asObject();
    private static final JsonAccessor<JsonObject> COUNT_DISTINCT_PROPERTY_ACCESSOR = JsonAccessor.root().property("cardinality").asObject();
    private static final JsonAccessor<String> FIELD_PROPERTY_ACCESSOR = JsonAccessor.root().property("field").asString();
    private final String absoluteFieldPath;
    private final JsonAccessor<JsonObject> operation;

    public static <F> Factory<F> count(ElasticsearchFieldCodec<F> codec) {
        return new Factory<F>(codec, COUNT_PROPERTY_ACCESSOR);
    }

    public static <F> Factory<F> countDistinct(ElasticsearchFieldCodec<F> codec) {
        return new Factory<F>(codec, COUNT_DISTINCT_PROPERTY_ACCESSOR);
    }

    private ElasticsearchMetricLongAggregation(Builder builder) {
        super(builder);
        this.absoluteFieldPath = builder.field.absolutePath();
        this.operation = builder.operation;
    }

    @Override
    protected final JsonObject doRequest(AggregationRequestContext context) {
        JsonObject outerObject = new JsonObject();
        JsonObject innerObject = new JsonObject();
        this.operation.set(outerObject, innerObject);
        FIELD_PROPERTY_ACCESSOR.set(innerObject, this.absoluteFieldPath);
        return outerObject;
    }

    @Override
    protected ElasticsearchSearchAggregation.Extractor<Long> extractor(AggregationRequestContext context) {
        return new MetricLongExtractor(this.nestedPathHierarchy, this.filter);
    }

    private static class Factory<F>
    extends AbstractElasticsearchCodecAwareSearchQueryElementFactory<SearchFilterableAggregationBuilder<Long>, F> {
        private final JsonAccessor<JsonObject> operation;

        private Factory(ElasticsearchFieldCodec<F> codec, JsonAccessor<JsonObject> operation) {
            super(codec);
            this.operation = operation;
        }

        @Override
        public SearchFilterableAggregationBuilder<Long> create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            return new Builder(scope, field, this.operation);
        }
    }

    private static class Builder
    extends AbstractElasticsearchNestableAggregation.AbstractBuilder<Long>
    implements SearchFilterableAggregationBuilder<Long> {
        private final JsonAccessor<JsonObject> operation;

        private Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<?> field, JsonAccessor<JsonObject> operation) {
            super(scope, field);
            this.operation = operation;
        }

        @Override
        public ElasticsearchMetricLongAggregation build() {
            return new ElasticsearchMetricLongAggregation(this);
        }
    }

    private static class MetricLongExtractor
    extends AbstractElasticsearchNestableAggregation.AbstractExtractor<Long> {
        protected MetricLongExtractor(List<String> nestedPathHierarchy, ElasticsearchSearchPredicate filter) {
            super(nestedPathHierarchy, filter);
        }

        @Override
        protected Long doExtract(JsonObject aggregationResult, AggregationExtractContext context) {
            JsonElement value = aggregationResult.get("value");
            return JsonElementTypes.LONG.fromElement(value);
        }
    }
}

