/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.logging.impl.QueryLog;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;

public class QueryLog_$logger
implements QueryLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = QueryLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public QueryLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void executingElasticsearchQuery(String path, Map<String, String> parameters, String bodyParts) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.executingElasticsearchQuery$str(), (Object)path, parameters, (Object)bodyParts);
    }

    protected String executingElasticsearchQuery$str() {
        return "HSEARCH400053: Executing Elasticsearch query on '%s' with parameters '%s': <%s>";
    }

    protected String cannotMixElasticsearchScopeWithOtherType$str() {
        return "HSEARCH400502: Invalid multi-index scope: a scope cannot span both a Elasticsearch index and another type of index. Base scope: '%1$s', incompatible (Elasticsearch) index: '%2$s'.";
    }

    @Override
    public final SearchException cannotMixElasticsearchScopeWithOtherType(IndexScopeBuilder baseScope, ElasticsearchIndexManager elasticsearchIndex, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchScopeWithOtherType$str(), baseScope, elasticsearchIndex), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String cannotMixElasticsearchScopeWithOtherBackend$str() {
        return "HSEARCH400503: Invalid multi-index scope: a scope cannot span multiple Elasticsearch backends. Base scope: '%1$s', incompatible index (from another backend): '%2$s'.";
    }

    @Override
    public final SearchException cannotMixElasticsearchScopeWithOtherBackend(IndexScopeBuilder baseScope, ElasticsearchIndexManager indexFromOtherBackend, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherPredicates$str() {
        return "HSEARCH400508: Invalid search predicate: '%1$s'. You must build the predicate from an Elasticsearch search scope.";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(SearchPredicate predicate) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherPredicates$str(), predicate));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixElasticsearchSearchSortWithOtherSorts$str() {
        return "HSEARCH400511: Invalid search sort: '%1$s'. You must build the sort from an Elasticsearch search scope.";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchSortWithOtherSorts(SearchSort sort) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchSortWithOtherSorts$str(), sort));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH400529: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }

    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(int ceiling) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchConflictingConstraints$str(), ceiling));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherProjections$str() {
        return "HSEARCH400538: Invalid search projection: '%1$s'. You must build the projection from an Elasticsearch search scope.";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(SearchProjection<?> projection) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherProjections$str(), projection));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fullTextFeaturesNotSupportedByFieldType$str() {
        return "HSEARCH400553: Full-text features (analysis, fuzziness, minimum should match) are not supported for fields of this type.";
    }

    @Override
    public final SearchException fullTextFeaturesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fullTextFeaturesNotSupportedByFieldType$str(), new Object[0]), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String explainRequiresTypeName$str() {
        return "HSEARCH400564: Invalid use of explain(Object id) on a query targeting multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.";
    }

    @Override
    public final SearchException explainRequiresTypeName(Set<String> targetedTypeNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresTypeName$str(), targetedTypeNames));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String explainRequiresTypeTargetedByQuery$str() {
        return "HSEARCH400565: Invalid mapped type name: '%2$s'. This type is not among the mapped types targeted by this query: %1$s.";
    }

    @Override
    public final SearchException explainRequiresTypeTargetedByQuery(Set<String> targetedTypeNames, String typeName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresTypeTargetedByQuery$str(), targetedTypeNames, typeName));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String explainUnknownDocument$str() {
        return "HSEARCH400566: Invalid document identifier: '%2$s'. No such document in index '%1$s'.";
    }

    @Override
    public final SearchException explainUnknownDocument(URLEncodedString indexName, URLEncodedString id) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainUnknownDocument$str(), indexName, id));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH400572: Invalid search predicate: '%1$s'. You must build the predicate from a scope targeting indexes %3$s or a superset of them, but the given predicate was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }

    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(SearchPredicate predicate, Set<String> predicateIndexes, Set<String> scopeIndexes, Set<String> scopeDifference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes, scopeDifference));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH400573: Invalid search sort: '%1$s'. You must build the sort from a scope targeting indexes %3$s or a superset of them, but the given sort was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }

    @Override
    public final SearchException sortDefinedOnDifferentIndexes(SearchSort sort, Set<String> sortIndexes, Set<String> scopeIndexes, Set<String> scopeDifference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sortDefinedOnDifferentIndexes$str(), sort, sortIndexes, scopeIndexes, scopeDifference));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH400574: Invalid search projection: '%1$s'. You must build the projection from a scope targeting indexes %3$s or a superset of them, but the given projection was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }

    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> projection, Set<String> projectionIndexes, Set<String> scopeIndexes, Set<String> scopeDifference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectionDefinedOnDifferentIndexes$str(), projection, projectionIndexes, scopeIndexes, scopeDifference));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String elasticsearchRangeAggregationRequiresCanonicalFormForRanges$str() {
        return "HSEARCH400580: Invalid range: '%1$s'. Elasticsearch range aggregations only accept ranges in the canonical form: (-Infinity, <value>) or [<value1>, <value2>) or [<value>, +Infinity). Call Range.canonical(...) to be sure to create such a range.";
    }

    @Override
    public final SearchException elasticsearchRangeAggregationRequiresCanonicalFormForRanges(Range<?> range) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchRangeAggregationRequiresCanonicalFormForRanges$str(), range));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherAggregations$str() {
        return "HSEARCH400581: Invalid search aggregation: '%1$s'. You must build the aggregation from an Elasticsearch search scope.";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherAggregations(SearchAggregation<?> aggregation) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherAggregations$str(), aggregation));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH400582: Invalid search aggregation: '%1$s'. You must build the aggregation from a scope targeting indexes %3$s or a superset of them, but the given aggregation was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }

    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> aggregation, Set<String> aggregationIndexes, Set<String> scopeIndexes, Set<String> scopeDifference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes, scopeDifference));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateAggregationKey$str() {
        return "HSEARCH400585: Duplicate aggregation definitions for key: '%1$s'";
    }

    @Override
    public final SearchException duplicateAggregationKey(AggregationKey<?> key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.duplicateAggregationKey$str(), new AggregationKeyFormatter(key)));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingTypeFieldInDocument$str() {
        return "HSEARCH400592: Missing field '%1$s' for one of the search hits. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }

    @Override
    public final SearchException missingTypeFieldInDocument(String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingTypeFieldInDocument$str(), fieldName));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSortModeAcrossNested$str() {
        return "HSEARCH400600: Invalid sort mode: %1$s. This sort mode is not supported for fields in nested documents.";
    }

    @Override
    public final SearchException invalidSortModeAcrossNested(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeAcrossNested$str(), mode), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSortModeForStringField$str() {
        return "HSEARCH400601: Invalid sort mode: %1$s. This sort mode is not supported for String fields. Only MIN and MAX are supported.";
    }

    @Override
    public final SearchException invalidSortModeForStringField(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeForStringField$str(), mode), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSortModeForTemporalField$str() {
        return "HSEARCH400602: Invalid sort mode: %1$s. This sort mode is not supported for temporal fields. Only MIN, MAX, AVG and MEDIAN are supported.";
    }

    @Override
    public final SearchException invalidSortModeForTemporalField(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeForTemporalField$str(), mode), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSortModeForDistanceSort$str() {
        return "HSEARCH400603: Invalid sort mode: %1$s. This sort mode is not supported for a distance sort. Only MIN, MAX, AVG and MEDIAN are supported.";
    }

    @Override
    public final SearchException invalidSortModeForDistanceSort(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeForDistanceSort$str(), mode), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFilterSortOnRootDocumentField$str() {
        return "HSEARCH400604: Invalid sort filter: field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.";
    }

    @Override
    public final SearchException cannotFilterSortOnRootDocumentField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFilterSortOnRootDocumentField$str(), absoluteFieldPath), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidNestedObjectPathForPredicate$str() {
        return "HSEARCH400605: Invalid search predicate: %1$s. This predicate targets fields %3$s, but only fields that are contained in the nested object with path '%2$s' are allowed here.";
    }

    @Override
    public final SearchException invalidNestedObjectPathForPredicate(SearchPredicate predicate, String nestedObjectPath, List<String> fieldPaths) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidNestedObjectPathForPredicate$str(), predicate, nestedObjectPath, fieldPaths));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFilterAggregationOnRootDocumentField$str() {
        return "HSEARCH400606: Invalid aggregation filter: field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.";
    }

    @Override
    public final SearchException cannotFilterAggregationOnRootDocumentField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFilterAggregationOnRootDocumentField$str(), absoluteFieldPath), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSingleValuedProjectionOnMultiValuedField$str() {
        return "HSEARCH400613: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is multi-valued. Make sure to call '.collector(...)' when you create the projection.";
    }

    @Override
    public final SearchException invalidSingleValuedProjectionOnMultiValuedField(String absolutePath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSingleValuedProjectionOnMultiValuedField$str(), absolutePath), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String differentImplementationClassForQueryElement$str() {
        return "HSEARCH400617: Implementation class differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentImplementationClassForQueryElement(Class<?> class1, Class<?> class2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentImplementationClassForQueryElement$str(), new ClassFormatter(class1), new ClassFormatter(class2)));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String differentFieldCodecForQueryElement$str() {
        return "HSEARCH400618: Field codec differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentFieldCodecForQueryElement(Object codec1, Object codec2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentFieldCodecForQueryElement$str(), codec1, codec2));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingFirstOnAscSortNotSupported$str() {
        return "HSEARCH400634: Invalid use of 'missing().first()' for an ascending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.";
    }

    @Override
    public final SearchException missingFirstOnAscSortNotSupported(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingFirstOnAscSortNotSupported$str(), new Object[0]), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingLastOnDescSortNotSupported$str() {
        return "HSEARCH400635: Invalid use of 'missing().last()' for a descending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.";
    }

    @Override
    public final SearchException missingLastOnDescSortNotSupported(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingLastOnDescSortNotSupported$str(), new Object[0]), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingAsOnSortNotSupported$str() {
        return "HSEARCH400636: Invalid use of 'missing().use(...)' for a distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.";
    }

    @Override
    public final SearchException missingAsOnSortNotSupported(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingAsOnSortNotSupported$str(), new Object[0]), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String differentPredicateDefinitionForQueryElement$str() {
        return "HSEARCH400638: Predicate definition differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentPredicateDefinitionForQueryElement(Object predicateDefinition1, Object predicateDefinition2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentPredicateDefinitionForQueryElement$str(), predicateDefinition1, predicateDefinition2));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void defaultedLimitedHits(Integer defaultLimit, long hitCount) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.defaultedLimitedHits$str(), (Object)defaultLimit, (Object)hitCount);
    }

    protected String defaultedLimitedHits$str() {
        return "HSEARCH400640: A search query fetching all hits was requested, but only '%2$s' hits were retrieved because the maximum result window size forces a limit of '%1$s' hits. Refer to Elasticsearch's 'max_result_window_size' setting for more information.";
    }

    protected String paramNotDefined$str() {
        return "HSEARCH400650: Param with name '%1$s' has not been defined for the named predicate '%2$s'.";
    }

    @Override
    public final SearchException paramNotDefined(String name, String predicateName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.paramNotDefined$str(), name, predicateName), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidContextForProjectionOnField$str() {
        return "HSEARCH400654: Invalid context for projection on field '%1$s': the surrounding projection is executed for each object in field '%2$s', which is not a parent of field '%1$s'. Check the structure of your projections.";
    }

    @Override
    public final SearchException invalidContextForProjectionOnField(String absolutePath, String objectFieldAbsolutePath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidContextForProjectionOnField$str(), absolutePath, objectFieldAbsolutePath));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str() {
        return "HSEARCH400655: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is effectively multi-valued in this context, because parent object field '%2$s' is multi-valued. Either call '.collector(...)' when you create the projection on field '%1$s', or wrap that projection in an object projection like this: 'f.object(\"%2$s\").from(<the projection on field %1$s>).as(...).collector(...)'.";
    }

    @Override
    public final SearchException invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(String absolutePath, String objectFieldAbsolutePath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str(), absolutePath, objectFieldAbsolutePath));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unexpectedMappedTypeNameForByMappedTypeProjection$str() {
        return "HSEARCH400656: Unexpected mapped type name extracted from hits: '%1$s'. Expected one of: %2$s. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }

    @Override
    public final SearchException unexpectedMappedTypeNameForByMappedTypeProjection(String typeName, Set<String> expectedTypeNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedMappedTypeNameForByMappedTypeProjection$str(), typeName, expectedTypeNames));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingLowestOnAscSortNotSupported$str() {
        return "HSEARCH400658: Invalid use of 'missing().lowest()' for an ascending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized. ";
    }

    @Override
    public final SearchException missingLowestOnAscSortNotSupported(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingLowestOnAscSortNotSupported$str(), new Object[0]), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingLowestOnDescSortNotSupported$str() {
        return "HSEARCH400659: Invalid use of 'missing().lowest()' for a descending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized. ";
    }

    @Override
    public final SearchException missingLowestOnDescSortNotSupported(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingLowestOnDescSortNotSupported$str(), new Object[0]), context);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherQueryHighlighters$str() {
        return "HSEARCH400660: Invalid highlighter: '%1$s'. You must build the highlighter from an Elasticsearch search scope.";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherQueryHighlighters(SearchHighlighter highlighter) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherQueryHighlighters$str(), highlighter));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String queryHighlighterDefinedOnDifferentIndexes$str() {
        return "HSEARCH400661: Invalid highlighter: '%1$s'. You must build the highlighter from a scope targeting indexes %3$s or a superset of them, but the given highlighter was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }

    @Override
    public final SearchException queryHighlighterDefinedOnDifferentIndexes(SearchHighlighter highlighter, Set<String> highlighterIndexes, Set<String> scopeIndexes, Set<String> scopeDifference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.queryHighlighterDefinedOnDifferentIndexes$str(), highlighter, highlighterIndexes, scopeIndexes, scopeDifference));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void noFieldsToHighlight() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noFieldsToHighlight$str(), new Object[0]);
    }

    protected String noFieldsToHighlight$str() {
        return "HSEARCH400662: No fields were added to be highlighted, but some query level highlighters were provided. These highlighters will be ignored.";
    }

    protected String cannotFindHighlighter$str() {
        return "HSEARCH400663: Cannot find a highlighter with name '%1$s'. Available highlighters are: %2$s. Was it configured with `highlighter(\"%1$s\", highlighterContributor)`?";
    }

    @Override
    public final SearchException cannotFindHighlighter(String highlighterName, Set<String> highlighters) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindHighlighter$str(), highlighterName, highlighters));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String highlighterNameCannotBeBlank$str() {
        return "HSEARCH400664: Named highlighters cannot use a blank string as name.";
    }

    @Override
    public final SearchException highlighterNameCannotBeBlank() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.highlighterNameCannotBeBlank$str(), new Object[0]));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String highlighterWithTheSameNameCannotBeAdded$str() {
        return "HSEARCH400665: Highlighter with name '%1$s' is already defined. Use a different name to add another highlighter.";
    }

    @Override
    public final SearchException highlighterWithTheSameNameCannotBeAdded(String highlighterName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.highlighterWithTheSameNameCannotBeAdded$str(), highlighterName));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String highlighterTypeNotSupported$str() {
        return "HSEARCH400666: '%1$s' highlighter type cannot be applied to '%2$s' field. '%2$s' must have either 'ANY' or '%1$s' among the configured highlightable values.";
    }

    @Override
    public final SearchException highlighterTypeNotSupported(SearchHighlighterType type, String field) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.highlighterTypeNotSupported$str(), type, field));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotHighlightInNestedContext$str() {
        return "HSEARCH400670: Highlight projection cannot be applied within nested context of '%1$s'.";
    }

    @Override
    public final SearchException cannotHighlightInNestedContext(String currentNestingField, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotHighlightInNestedContext$str(), currentNestingField), eventContext);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotHighlightFieldFromNestedObjectStructure$str() {
        return "HSEARCH400671: The highlight projection cannot be applied to a field from an object using `ObjectStructure.NESTED` structure.";
    }

    @Override
    public final SearchException cannotHighlightFieldFromNestedObjectStructure(EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotHighlightFieldFromNestedObjectStructure$str(), new Object[0]), eventContext);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseProjectionInNestedContext$str() {
        return "HSEARCH400672: '%1$s' cannot be nested in an object projection. %2$s";
    }

    @Override
    public final SearchException cannotUseProjectionInNestedContext(String projection, String hint, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseProjectionInNestedContext$str(), projection, hint), eventContext);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String vectorKnnMatchVectorTypeDiffersFromField$str() {
        return "HSEARCH400681: Vector field '%1$s' is defined as a '%2$s' array. Matching against '%3$s' array is unsupported. Use the array of the same type as the vector field.";
    }

    @Override
    public final SearchException vectorKnnMatchVectorTypeDiffersFromField(String absoluteFieldPath, Class<?> expected, Class<?> actual) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.vectorKnnMatchVectorTypeDiffersFromField$str(), absoluteFieldPath, new ClassFormatter(expected), new ClassFormatter(actual)));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String vectorKnnMatchVectorDimensionDiffersFromField$str() {
        return "HSEARCH400682: Vector field '%1$s' is defined as a vector with '%2$s' dimensions (array length). Matching against an array with length of '%3$s' is unsupported. Use the array of the same size as the vector field.";
    }

    @Override
    public final SearchException vectorKnnMatchVectorDimensionDiffersFromField(String absoluteFieldPath, int expected, int actual) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.vectorKnnMatchVectorDimensionDiffersFromField$str(), absoluteFieldPath, expected, actual));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String knnRequiredMinimumSimilarityUnsupportedOption$str() {
        return "HSEARCH400687: An OpenSearch distribution does not allow specifying the `required minimum similarity` option. This option is only applicable to an Elastic distribution of an Elasticsearch backend.";
    }

    @Override
    public final SearchException knnRequiredMinimumSimilarityUnsupportedOption() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.knnRequiredMinimumSimilarityUnsupportedOption$str(), new Object[0]));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void knnUsedInNestedContextRequiresFilters() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.knnUsedInNestedContextRequiresFilters$str(), new Object[0]);
    }

    protected String knnUsedInNestedContextRequiresFilters$str() {
        return "HSEARCH400689: Using a knn predicate in the nested context when tenant or routing filters are required will lead to unpredictable results and may return fewer documents then expected.";
    }

    protected String highlighterIncompatibleCardinality$str() {
        return "HSEARCH400690: A single-valued highlight projection requested, but the corresponding highlighter does not set number of fragments to 1.";
    }

    @Override
    public final SearchException highlighterIncompatibleCardinality() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.highlighterIncompatibleCardinality$str(), new Object[0]));
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

