/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.gson.impl.SerializeExtraProperties;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.Analysis;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettingsJsonAdapterFactory;

@JsonAdapter(value=IndexSettingsJsonAdapterFactory.class)
public class IndexSettings {
    public static final String MAX_RESULT_WINDOW_ATTRIBUTE = "max_result_window";
    public static final String KNN_ATTRIBUTE = "knn";
    public static final int MAX_RESULT_WINDOW_DEFAULT = 10000;
    private Analysis analysis;
    @SerializedName(value="max_result_window")
    private Integer maxResultWindow;
    @SerializedName(value="knn")
    private Boolean knn;
    @SerializeExtraProperties
    private Map<String, JsonElement> extraAttributes;

    public IndexSettings() {
    }

    public IndexSettings(Analysis analysis, Integer maxResultWindow, Map<String, JsonElement> extraAttributes) {
        this.analysis = analysis;
        this.maxResultWindow = maxResultWindow;
        this.extraAttributes = extraAttributes;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(Analysis analysis) {
        this.analysis = analysis;
    }

    public Integer getMaxResultWindow() {
        return this.maxResultWindow;
    }

    public Boolean getKnn() {
        return this.knn;
    }

    public void setKnn(Boolean knn) {
        this.knn = knn;
    }

    public Map<String, JsonElement> getExtraAttributes() {
        return this.extraAttributes;
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }

    public void merge(IndexSettings other) {
        if (other == null) {
            return;
        }
        if (this.analysis == null) {
            this.analysis = other.analysis;
        } else {
            this.analysis.merge(other.analysis);
        }
        if (this.maxResultWindow == null) {
            this.maxResultWindow = other.maxResultWindow;
        }
        if (this.knn == null) {
            this.knn = other.knn;
        }
        if (this.extraAttributes == null) {
            this.extraAttributes = other.extraAttributes;
        }
    }

    public IndexSettings diff(Map<String, JsonElement> extraAttributesToRemove) {
        if (this.extraAttributes == null || this.extraAttributes.isEmpty()) {
            return this;
        }
        HashSet<String> keysToRemove = new HashSet<String>();
        for (Map.Entry<String, JsonElement> extraAttribute : this.extraAttributes.entrySet()) {
            String key = extraAttribute.getKey();
            if (!extraAttributesToRemove.containsKey(key) || !Objects.equals(extraAttributesToRemove.get(key), extraAttribute.getValue())) continue;
            keysToRemove.add(key);
        }
        if (keysToRemove.isEmpty()) {
            return this;
        }
        HashMap<String, JsonElement> newExtraAttributes = new HashMap<String, JsonElement>(this.extraAttributes);
        for (String key : keysToRemove) {
            newExtraAttributes.remove(key);
        }
        return new IndexSettings(this.analysis, this.maxResultWindow, newExtraAttributes);
    }
}

