/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchNestableAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.aggregation.spi.FieldMetricAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueModel;

public class ElasticsearchMetricFieldAggregation<F, K>
extends AbstractElasticsearchNestableAggregation<K> {
    private static final JsonAccessor<JsonObject> SUM_PROPERTY_ACCESSOR = JsonAccessor.root().property("sum").asObject();
    private static final JsonAccessor<JsonObject> MIN_PROPERTY_ACCESSOR = JsonAccessor.root().property("min").asObject();
    private static final JsonAccessor<JsonObject> MAX_PROPERTY_ACCESSOR = JsonAccessor.root().property("max").asObject();
    private static final JsonAccessor<JsonObject> AVG_PROPERTY_ACCESSOR = JsonAccessor.root().property("avg").asObject();
    private static final JsonAccessor<String> FIELD_PROPERTY_ACCESSOR = JsonAccessor.root().property("field").asString();
    private static final JsonAccessor<Double> VALUE_ACCESSOR = JsonAccessor.root().property("value").asDouble();
    private final String absoluteFieldPath;
    private final AggregationExtractorBuilder<K> metricFieldExtractorCreator;
    private final JsonAccessor<JsonObject> operation;

    public static <F> Factory<F> sum(ElasticsearchFieldCodec<F> codec) {
        return new Factory<F>(codec, SUM_PROPERTY_ACCESSOR);
    }

    public static <F> Factory<F> min(ElasticsearchFieldCodec<F> codec) {
        return new Factory<F>(codec, MIN_PROPERTY_ACCESSOR);
    }

    public static <F> Factory<F> max(ElasticsearchFieldCodec<F> codec) {
        return new Factory<F>(codec, MAX_PROPERTY_ACCESSOR);
    }

    public static <F> Factory<F> avg(ElasticsearchFieldCodec<F> codec) {
        return new Factory<F>(codec, AVG_PROPERTY_ACCESSOR);
    }

    private ElasticsearchMetricFieldAggregation(Builder<F, K> builder) {
        super(builder);
        this.absoluteFieldPath = builder.field.absolutePath();
        this.metricFieldExtractorCreator = builder.metricFieldExtractorCreator;
        this.operation = builder.operation;
    }

    @Override
    protected final JsonObject doRequest(AggregationRequestContext context) {
        JsonObject outerObject = new JsonObject();
        JsonObject innerObject = new JsonObject();
        this.operation.set(outerObject, innerObject);
        FIELD_PROPERTY_ACCESSOR.set(innerObject, this.absoluteFieldPath);
        return outerObject;
    }

    @Override
    protected ElasticsearchSearchAggregation.Extractor<K> extractor(AggregationRequestContext context) {
        return this.metricFieldExtractorCreator.extractor(this.filter);
    }

    private static class Factory<F>
    extends AbstractElasticsearchCodecAwareSearchQueryElementFactory<FieldMetricAggregationBuilder.TypeSelector, F> {
        private final JsonAccessor<JsonObject> operation;

        private Factory(ElasticsearchFieldCodec<F> codec, JsonAccessor<JsonObject> operation) {
            super(codec);
            this.operation = operation;
        }

        @Override
        public FieldMetricAggregationBuilder.TypeSelector create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            return new TypeSelector<F>(this.codec, scope, field, this.operation);
        }
    }

    private static class Builder<F, K>
    extends AbstractElasticsearchNestableAggregation.AbstractBuilder<K>
    implements FieldMetricAggregationBuilder<K> {
        private final AggregationExtractorBuilder<K> metricFieldExtractorCreator;
        private final JsonAccessor<JsonObject> operation;

        private Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field, AggregationExtractorBuilder<K> metricFieldExtractorCreator, JsonAccessor<JsonObject> operation) {
            super(scope, field);
            this.metricFieldExtractorCreator = metricFieldExtractorCreator;
            this.operation = operation;
        }

        @Override
        public ElasticsearchMetricFieldAggregation<F, K> build() {
            return new ElasticsearchMetricFieldAggregation(this);
        }
    }

    private static abstract class AggregationExtractorBuilder<K> {
        protected final List<String> nestedPathHierarchy;

        protected AggregationExtractorBuilder(List<String> nestedPathHierarchy) {
            this.nestedPathHierarchy = nestedPathHierarchy;
        }

        abstract AbstractElasticsearchNestableAggregation.AbstractExtractor<K> extractor(ElasticsearchSearchPredicate var1);
    }

    private static class RawMetricFieldExtractor<K>
    extends AbstractElasticsearchNestableAggregation.AbstractExtractor<K> {
        private final ProjectionConverter<JsonElement, K> projectionConverter;

        protected RawMetricFieldExtractor(List<String> nestedPathHierarchy, ElasticsearchSearchPredicate filter, ProjectionConverter<JsonElement, K> projectionConverter) {
            super(nestedPathHierarchy, filter);
            this.projectionConverter = projectionConverter;
        }

        @Override
        protected K doExtract(JsonObject aggregationResult, AggregationExtractContext context) {
            FromDocumentValueConvertContext convertContext = context.fromDocumentValueConvertContext();
            return (K)this.projectionConverter.fromDocumentValue((Object)aggregationResult, convertContext);
        }

        private static class Builder<K>
        extends AggregationExtractorBuilder<K> {
            private final ProjectionConverter<JsonElement, K> projectionConverter;

            private Builder(List<String> nestedPathHierarchy, ProjectionConverter<JsonElement, K> projectionConverter) {
                super(nestedPathHierarchy);
                this.projectionConverter = projectionConverter;
            }

            @Override
            AbstractElasticsearchNestableAggregation.AbstractExtractor<K> extractor(ElasticsearchSearchPredicate filter) {
                return new RawMetricFieldExtractor<K>(this.nestedPathHierarchy, filter, this.projectionConverter);
            }
        }
    }

    private static class DoubleMetricFieldExtractor
    extends AbstractElasticsearchNestableAggregation.AbstractExtractor<Double> {
        protected DoubleMetricFieldExtractor(List<String> nestedPathHierarchy, ElasticsearchSearchPredicate filter) {
            super(nestedPathHierarchy, filter);
        }

        @Override
        protected Double doExtract(JsonObject aggregationResult, AggregationExtractContext context) {
            Optional<Double> value = VALUE_ACCESSOR.get(aggregationResult);
            return value.orElse(null);
        }

        private static class Builder
        extends AggregationExtractorBuilder<Double> {
            private Builder(List<String> nestedPathHierarchy) {
                super(nestedPathHierarchy);
            }

            @Override
            AbstractElasticsearchNestableAggregation.AbstractExtractor<Double> extractor(ElasticsearchSearchPredicate filter) {
                return new DoubleMetricFieldExtractor(this.nestedPathHierarchy, filter);
            }
        }
    }

    private static class MetricFieldExtractor<F, K>
    extends AbstractElasticsearchNestableAggregation.AbstractExtractor<K> {
        private final ProjectionConverter<F, ? extends K> fromFieldValueConverter;
        private final ElasticsearchFieldCodec<F> codec;

        protected MetricFieldExtractor(List<String> nestedPathHierarchy, ElasticsearchSearchPredicate filter, ProjectionConverter<F, ? extends K> fromFieldValueConverter, ElasticsearchFieldCodec<F> codec) {
            super(nestedPathHierarchy, filter);
            this.fromFieldValueConverter = fromFieldValueConverter;
            this.codec = codec;
        }

        @Override
        protected K doExtract(JsonObject aggregationResult, AggregationExtractContext context) {
            FromDocumentValueConvertContext convertContext = context.fromDocumentValueConvertContext();
            Optional<Double> value = VALUE_ACCESSOR.get(aggregationResult);
            JsonElement valueAsString = aggregationResult.get("value_as_string");
            return (K)this.fromFieldValueConverter.fromDocumentValue(this.codec.decodeAggregationValue(value, valueAsString), convertContext);
        }

        private static class Builder<F, K>
        extends AggregationExtractorBuilder<K> {
            private final ProjectionConverter<F, ? extends K> fromFieldValueConverter;
            private final ElasticsearchFieldCodec<F> codec;

            private Builder(List<String> nestedPathHierarchy, ProjectionConverter<F, ? extends K> fromFieldValueConverter, ElasticsearchFieldCodec<F> codec) {
                super(nestedPathHierarchy);
                this.fromFieldValueConverter = fromFieldValueConverter;
                this.codec = codec;
            }

            @Override
            AbstractElasticsearchNestableAggregation.AbstractExtractor<K> extractor(ElasticsearchSearchPredicate filter) {
                return new MetricFieldExtractor<F, K>(this.nestedPathHierarchy, filter, this.fromFieldValueConverter, this.codec);
            }
        }
    }

    private static class TypeSelector<F>
    implements FieldMetricAggregationBuilder.TypeSelector {
        private final ElasticsearchFieldCodec<F> codec;
        private final ElasticsearchSearchIndexScope<?> scope;
        private final ElasticsearchSearchIndexValueFieldContext<F> field;
        private final JsonAccessor<JsonObject> operation;

        private TypeSelector(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field, JsonAccessor<JsonObject> operation) {
            this.codec = codec;
            this.scope = scope;
            this.field = field;
            this.operation = operation;
        }

        public <T> Builder<F, T> type(Class<T> expectedType, ValueModel valueModel) {
            AggregationExtractorBuilder metricFieldExtractorCreator;
            if (ValueModel.RAW.equals((Object)valueModel)) {
                if (Double.class.isAssignableFrom(expectedType)) {
                    metricFieldExtractorCreator = new DoubleMetricFieldExtractor.Builder(this.field.nestedPathHierarchy());
                } else {
                    ProjectionConverter projectionConverter = this.field.type().rawProjectionConverter().withConvertedType(expectedType, this.field);
                    metricFieldExtractorCreator = new RawMetricFieldExtractor.Builder(this.field.nestedPathHierarchy(), projectionConverter);
                }
            } else {
                ProjectionConverter projectionConverter = this.field.type().projectionConverter(valueModel).withConvertedType(expectedType, this.field);
                metricFieldExtractorCreator = new MetricFieldExtractor.Builder(this.field.nestedPathHierarchy(), projectionConverter, this.codec);
            }
            return new Builder<F, Double>(this.scope, this.field, metricFieldExtractorCreator, this.operation);
        }
    }
}

