/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.dsl.impl;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.predicate.dsl.ElasticsearchSearchPredicateFactory;
import org.hibernate.search.backend.elasticsearch.search.projection.dsl.ElasticsearchSearchProjectionFactory;
import org.hibernate.search.backend.elasticsearch.search.query.dsl.ElasticsearchSearchQueryOptionsStep;
import org.hibernate.search.backend.elasticsearch.search.query.dsl.ElasticsearchSearchQuerySelectStep;
import org.hibernate.search.backend.elasticsearch.search.query.dsl.ElasticsearchSearchQueryWhereStep;
import org.hibernate.search.backend.elasticsearch.search.query.dsl.impl.ElasticsearchSearchQueryOptionsStepImpl;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryIndexScope;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SimpleBooleanPredicateClausesCollector;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.projection.spi.ProjectionCompositor;
import org.hibernate.search.engine.search.query.dsl.spi.AbstractSearchQuerySelectStep;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;
import org.hibernate.search.engine.search.query.spi.SearchQueryIndexScope;

public class ElasticsearchSearchQuerySelectStepImpl<SR, R, E, LOS>
extends AbstractSearchQuerySelectStep<SR, ElasticsearchSearchQueryOptionsStep<SR, E, LOS>, R, E, LOS, ElasticsearchSearchProjectionFactory<SR, R, E>, ElasticsearchSearchPredicateFactory<SR>>
implements ElasticsearchSearchQuerySelectStep<SR, R, E, LOS> {
    private final ElasticsearchSearchQueryIndexScope<?> scope;
    private final BackendSessionContext sessionContext;
    private final SearchLoadingContextBuilder<E, LOS> loadingContextBuilder;

    public ElasticsearchSearchQuerySelectStepImpl(ElasticsearchSearchQueryIndexScope<?> scope, BackendSessionContext sessionContext, SearchLoadingContextBuilder<E, LOS> loadingContextBuilder) {
        this.scope = scope;
        this.sessionContext = sessionContext;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    @Override
    public ElasticsearchSearchQueryWhereStep<SR, E, LOS> selectEntity() {
        return this.select(this.scope.projectionFactory().entity().toProjection());
    }

    @Override
    public ElasticsearchSearchQueryWhereStep<SR, R, LOS> selectEntityReference() {
        return this.select(this.scope.projectionBuilders().entityReference());
    }

    @Override
    public <P> ElasticsearchSearchQueryWhereStep<SR, P, LOS> select(Class<P> objectClass) {
        return this.select(this.scope.projectionFactory().composite().as(objectClass).toProjection());
    }

    @Override
    public <P> ElasticsearchSearchQueryWhereStep<SR, P, LOS> select(Function<? super ElasticsearchSearchProjectionFactory<SR, R, E>, ? extends ProjectionFinalStep<P>> projectionContributor) {
        SearchProjection projection = projectionContributor.apply(this.scope.projectionFactory()).toProjection();
        return this.select(projection);
    }

    @Override
    public <P> ElasticsearchSearchQueryWhereStep<SR, P, LOS> select(SearchProjection<P> projection) {
        SearchQueryBuilder builder = this.scope.select(this.sessionContext, (SearchLoadingContextBuilder)this.loadingContextBuilder, (SearchProjection)projection);
        return new ElasticsearchSearchQueryOptionsStepImpl(this.scope, builder, this.loadingContextBuilder);
    }

    @Override
    public ElasticsearchSearchQueryWhereStep<SR, List<?>, LOS> select(SearchProjection<?> ... projections) {
        return this.select(this.scope.projectionBuilders().composite().build(projections, ProjectionCompositor.fromList((int)projections.length), ProjectionCollector.nullable()));
    }

    public ElasticsearchSearchQueryOptionsStep<SR, E, LOS> where(SearchPredicate predicate) {
        return (ElasticsearchSearchQueryOptionsStep)this.selectEntity().where(predicate);
    }

    public ElasticsearchSearchQueryOptionsStep<SR, E, LOS> where(Function<? super ElasticsearchSearchPredicateFactory<SR>, ? extends PredicateFinalStep> predicateContributor) {
        return (ElasticsearchSearchQueryOptionsStep)this.selectEntity().where(predicateContributor);
    }

    public ElasticsearchSearchQueryOptionsStep<SR, E, LOS> where(BiConsumer<? super ElasticsearchSearchPredicateFactory<SR>, ? super SimpleBooleanPredicateClausesCollector<SR, ?>> predicateContributor) {
        return (ElasticsearchSearchQueryOptionsStep)this.selectEntity().where(predicateContributor);
    }

    protected SearchQueryIndexScope<?> scope() {
        return this.scope;
    }

    protected BackendSessionContext sessionContext() {
        return this.sessionContext;
    }

    protected SearchLoadingContextBuilder<E, LOS> loadingContextBuilder() {
        return this.loadingContextBuilder;
    }
}

