package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.util.Locale;
import org.hibernate.search.util.common.reporting.EventContext;
import java.io.Serializable;
import com.google.gson.JsonElement;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.Exception;

/**
 * Warning this class consists of generated code.
 */
public class AnalysisLog_$logger implements AnalysisLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = AnalysisLog_$logger.class.getName();
    public AnalysisLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String tokenizerNamingConflict$str() {
        return "HSEARCH400055: Duplicate tokenizer definitions: '%1$s'. Tokenizer names must be unique.";
    }
    @Override
    public final SearchException tokenizerNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tokenizerNamingConflict$str(), remoteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String charFilterNamingConflict$str() {
        return "HSEARCH400056: Duplicate char filter definitions: '%1$s'. Char filter names must be unique.";
    }
    @Override
    public final SearchException charFilterNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), charFilterNamingConflict$str(), remoteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tokenFilterNamingConflict$str() {
        return "HSEARCH400057: Duplicate token filter definitions: '%1$s'. Token filter names must be unique.";
    }
    @Override
    public final SearchException tokenFilterNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tokenFilterNamingConflict$str(), remoteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToApplyAnalysisConfiguration$str() {
        return "HSEARCH400075: Unable to apply analysis configuration: %1$s";
    }
    @Override
    public final SearchException unableToApplyAnalysisConfiguration(final String errorMessage, final Exception e, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToApplyAnalysisConfiguration$str(), errorMessage), e, eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchAnalyzerDefinition$str() {
        return "HSEARCH400076: Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.";
    }
    @Override
    public final SearchException invalidElasticsearchAnalyzerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchAnalyzerDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchTokenizerDefinition$str() {
        return "HSEARCH400077: Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.";
    }
    @Override
    public final SearchException invalidElasticsearchTokenizerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTokenizerDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchCharFilterDefinition$str() {
        return "HSEARCH400078: Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.";
    }
    @Override
    public final SearchException invalidElasticsearchCharFilterDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchCharFilterDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchTokenFilterDefinition$str() {
        return "HSEARCH400079: Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.";
    }
    @Override
    public final SearchException invalidElasticsearchTokenFilterDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTokenFilterDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchTypedAnalyzerDefinition$str() {
        return "HSEARCH400534: Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.";
    }
    @Override
    public final SearchException invalidElasticsearchTypedAnalyzerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTypedAnalyzerDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return "HSEARCH400535: Invalid index field type: both analyzer '%1$s' and normalizer '%2$s' are assigned to this type. Either an analyzer or a normalizer can be assigned, but not both.";
    }
    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(final String analyzerName, final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH400536: Invalid index field type: both analyzer '%1$s' and sorts are enabled. Sorts are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String analysisComponentParameterConflict$str() {
        return "HSEARCH400537: Ambiguous value for parameter '%1$s': this parameter is set to two different values '%2$s' and '%3$s'.";
    }
    @Override
    public final SearchException analysisComponentParameterConflict(final String name, final JsonElement value1, final JsonElement value2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analysisComponentParameterConflict$str(), name, value1, value2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String skipAnalysisOnNormalizedField$str() {
        return "HSEARCH400560: Cannot skip analysis on field '%1$s': the Elasticsearch backend will always normalize arguments before attempting matches on normalized fields.";
    }
    @Override
    public final SearchException skipAnalysisOnNormalizedField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), skipAnalysisOnNormalizedField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH400562: Invalid index field type: both null token '%2$s' ('indexNullAs') and analyzer '%1$s' are assigned to this type. 'indexNullAs' is not supported on analyzed fields.";
    }
    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(final String analyzerName, final String indexNullAs, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseAnalyzerOnAggregableField$str() {
        return "HSEARCH400576: Invalid index field type: both analyzer '%1$s' and aggregations are enabled. Aggregations are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnAggregableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnAggregableField$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String searchAnalyzerWithoutAnalyzer$str() {
        return "HSEARCH400587: Invalid index field type: search analyzer '%1$s' is assigned to this type, but the indexing analyzer is missing. Assign an indexing analyzer and a search analyzer, or remove the search analyzer.";
    }
    @Override
    public final SearchException searchAnalyzerWithoutAnalyzer(final String searchAnalyzer, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), searchAnalyzerWithoutAnalyzer$str(), searchAnalyzer), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
