package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.util.Locale;
import org.hibernate.search.util.common.reporting.EventContext;
import java.io.Serializable;
import java.util.Set;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.util.common.SearchException;
import java.util.List;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class ConfigurationLog_$logger implements ConfigurationLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigurationLog_$logger.class.getName();
    public ConfigurationLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invalidIndexStatus$str() {
        return "HSEARCH400022: Invalid index status: '%1$s'. Valid statuses are: %2$s.";
    }
    @Override
    public final SearchException invalidIndexStatus(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexStatus$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH400515: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidMultiTenancyStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH400516: Invalid tenant identifiers: '%1$s'. No tenant identifier is expected, because multi-tenancy is disabled for this backend.";
    }
    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(final Set<String> tenantIds, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tenantIdProvidedButMultiTenancyDisabled$str(), tenantIds), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH400517: Missing tenant identifier. A tenant identifier is expected, because multi-tenancy is enabled for this backend.";
    }
    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyEnabledButNoTenantIdProvided$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchDistributionName$str() {
        return "HSEARCH400558: Invalid Elasticsearch distribution name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidElasticsearchDistributionName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchDistributionName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHostAndPort$str() {
        return "HSEARCH400589: Invalid host/port: '%1$s'. The host/port string must use the format 'host:port', for example 'mycompany.com:9200' The URI scheme ('http://', 'https://') must not be included.";
    }
    @Override
    public final SearchException invalidHostAndPort(final String hostAndPort, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidHostAndPort$str(), hostAndPort), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTypeNameMappingStrategyName$str() {
        return "HSEARCH400591: Invalid name for the type-name mapping strategy: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidTypeNameMappingStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidTypeNameMappingStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDynamicType$str() {
        return "HSEARCH400621: Invalid dynamic type: '%1$s'. Valid values are: %2$s.";
    }
    @Override
    public final SearchException invalidDynamicType(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDynamicType$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String uriAndProtocol$str() {
        return "HSEARCH400626: Invalid target hosts configuration: both the 'uris' property and the 'protocol' property are set. Uris: '%1$s'. Protocol: '%2$s'. Either set the protocol and hosts simultaneously using the 'uris' property, or set them separately using the 'protocol' property and the 'hosts' property.";
    }
    @Override
    public final SearchException uriAndProtocol(final List<String> uris, final String protocol) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), uriAndProtocol$str(), uris, protocol));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String uriAndHosts$str() {
        return "HSEARCH400627: Invalid target hosts configuration: both the 'uris' property and the 'hosts' property are set. Uris: '%1$s'. Hosts: '%2$s'. Either set the protocol and hosts simultaneously using the 'uris' property, or set them separately using the 'protocol' property and the 'hosts' property.";
    }
    @Override
    public final SearchException uriAndHosts(final List<String> uris, final List<String> hosts) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), uriAndHosts$str(), uris, hosts));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentProtocolsOnUris$str() {
        return "HSEARCH400628: Invalid target hosts configuration: the 'uris' use different protocols (http, https). All URIs must use the same protocol. Uris: '%1$s'.";
    }
    @Override
    public final SearchException differentProtocolsOnUris(final List<String> uris) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentProtocolsOnUris$str(), uris));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyListOfHosts$str() {
        return "HSEARCH400629: Invalid target hosts configuration: the list of hosts must not be empty.";
    }
    @Override
    public final SearchException emptyListOfHosts() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), emptyListOfHosts$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyListOfUris$str() {
        return "HSEARCH400630: Invalid target hosts configuration: the list of URIs must not be empty.";
    }
    @Override
    public final SearchException emptyListOfUris() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), emptyListOfUris$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyRequiredButExplicitlyDisabledByBackend$str() {
        return "HSEARCH400648: Invalid backend configuration: mapping requires multi-tenancy but no multi-tenancy strategy is set.";
    }
    @Override
    public final SearchException multiTenancyRequiredButExplicitlyDisabledByBackend() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyRequiredButExplicitlyDisabledByBackend$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str() {
        return "HSEARCH400649: Invalid backend configuration: mapping requires single-tenancy but multi-tenancy strategy is set.";
    }
    @Override
    public final SearchException multiTenancyNotRequiredButExplicitlyEnabledByTheBackend() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void backendClientFactory(final BeanHolder<?> clientFactoryHolder, final String eventContext) {
        log.logf(FQCN, DEBUG, null, backendClientFactory$str(), clientFactoryHolder, eventContext);
    }
    protected String backendClientFactory$str() {
        return "HSEARCH400692: Elasticsearch backend will use client factory '%s'. Context: %s";
    }
}
