package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.hibernate.search.util.common.SearchException;
import org.jboss.logging.Logger;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class DeprecationLog_$logger implements DeprecationLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DeprecationLog_$logger.class.getName();
    public DeprecationLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String lifecycleStrategyMovedToMapper$str() {
        return "HSEARCH400598: The lifecycle strategy cannot be set at the index level anymore. Set the schema management strategy via the property 'hibernate.search.schema_management.strategy' instead.";
    }
    @Override
    public final SearchException lifecycleStrategyMovedToMapper() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), lifecycleStrategyMovedToMapper$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
}
