package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.util.Locale;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import java.util.regex.Pattern;
import java.io.Serializable;
import org.hibernate.search.util.common.AssertionFailure;
import java.util.Set;
import org.hibernate.search.util.common.SearchException;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import java.time.Duration;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.common.SearchTimeoutException;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class ElasticsearchClientLog_$logger implements ElasticsearchClientLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElasticsearchClientLog_$logger.class.getName();
    public ElasticsearchClientLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String elasticsearchRequestFailed$str() {
        return "HSEARCH400007: Elasticsearch request failed: %3$s\nRequest: %1$s\nResponse: %2$s";
    }
    @Override
    public final SearchException elasticsearchRequestFailed(final ElasticsearchRequest request, final ElasticsearchResponse response, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchRequestFailed$str(), new ElasticsearchRequestFormatter(request), new ElasticsearchResponseFormatter(response), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String elasticsearchBulkedRequestFailed$str() {
        return "HSEARCH400008: Elasticsearch bulked request failed: %3$s\nRequest metadata: %1$sResponse: %2$s";
    }
    @Override
    public final SearchException elasticsearchBulkedRequestFailed(final JsonObject requestMetadata, final JsonObject response, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchBulkedRequestFailed$str(), new ElasticsearchJsonObjectFormatter(requestMetadata), new ElasticsearchJsonObjectFormatter(response), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchStatus408RequestTimeout$str() {
        return "HSEARCH400010: Elasticsearch response indicates a timeout (HTTP status 408)";
    }
    @Override
    public final SearchException elasticsearchStatus408RequestTimeout() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchStatus408RequestTimeout$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchMappingUpdateFailed$str() {
        return "HSEARCH400020: Unable to update mapping for index '%1$s': %2$s";
    }
    @Override
    public final SearchException elasticsearchMappingUpdateFailed(final String indexName, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchMappingUpdateFailed$str(), indexName, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedIndexStatus$str() {
        return "HSEARCH400024: Index '%1$s' failed to reach status '%2$s' after %3$sms.";
    }
    @Override
    public final SearchException unexpectedIndexStatus(final URLEncodedString indexName, final String expected, final int requiredStatusTimeoutInMs, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedIndexStatus$str(), indexName, expected, requiredStatusTimeoutInMs), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchIndexMetadataRetrievalFailed$str() {
        return "HSEARCH400034: Unable to retrieve index metadata from Elasticsearch: %1$s";
    }
    @Override
    public final SearchException elasticsearchIndexMetadataRetrievalFailed(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchIndexMetadataRetrievalFailed$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String schemaUpdateFailed$str() {
        return "HSEARCH400035: Unable to update schema for index '%1$s': %2$s";
    }
    @Override
    public final SearchException schemaUpdateFailed(final URLEncodedString indexName, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), schemaUpdateFailed$str(), indexName, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexMissing$str() {
        return "HSEARCH400050: Missing index: index names [%1$s, %2$s] do not point to any index in the Elasticsearch cluster.";
    }
    @Override
    public final SearchException indexMissing(final URLEncodedString write, final URLEncodedString read) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexMissing$str(), write, read));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchSettingsUpdateFailed$str() {
        return "HSEARCH400067: Unable to update settings for index '%1$s': %2$s";
    }
    @Override
    public final SearchException elasticsearchSettingsUpdateFailed(final Object indexName, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchSettingsUpdateFailed$str(), indexName, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void closedIndex(final Object indexName) {
        log.logf(FQCN, INFO, null, closedIndex$str(), indexName);
    }
    protected String closedIndex$str() {
        return "HSEARCH400069: Closed Elasticsearch index '%1$s' automatically.";
    }
    @Override
    public final void openedIndex(final Object indexName) {
        log.logf(FQCN, INFO, null, openedIndex$str(), indexName);
    }
    protected String openedIndex$str() {
        return "HSEARCH400070: Opened Elasticsearch index '%1$s' automatically.";
    }
    @Override
    public final void usingPasswordOverHttp() {
        log.logf(FQCN, WARN, null, usingPasswordOverHttp$str());
    }
    protected String usingPasswordOverHttp$str() {
        return "HSEARCH400073: Hibernate Search will connect to Elasticsearch with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.";
    }
    protected String failedToParseElasticsearchResponse$str() {
        return "HSEARCH400089: Unable to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'. Nested exception: %3$s";
    }
    @Override
    public final SearchException failedToParseElasticsearchResponse(final int statusCode, final String statusPhrase, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToParseElasticsearchResponse$str(), statusCode, statusPhrase, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchResponseIndicatesFailure$str() {
        return "HSEARCH400090: Elasticsearch response indicates a failure.";
    }
    @Override
    public final SearchException elasticsearchResponseIndicatesFailure() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchResponseIndicatesFailure$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH400525: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldForDocumentElement(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchResponseMissingData$str() {
        return "HSEARCH400526: Missing data in the Elasticsearch response.";
    }
    @Override
    public final AssertionFailure elasticsearchResponseMissingData() {
        final AssertionFailure result = new AssertionFailure(String.format(getLoggingLocale(), elasticsearchResponseMissingData$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchResponseUnknownIndexName$str() {
        return "HSEARCH400531: Unable to resolve index name '%1$s' to an entity type: %2$s";
    }
    @Override
    public final SearchException elasticsearchResponseUnknownIndexName(final String elasticsearchIndexName, final String causeMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchResponseUnknownIndexName$str(), elasticsearchIndexName, causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToShutdownClient$str() {
        return "HSEARCH400544: Unable to shut down the Elasticsearch client: %1$s";
    }
    @Override
    public final SearchException unableToShutdownClient(final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToShutdownClient$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchFailedBecauseOfBulkFailure$str() {
        return "HSEARCH400588: Call to the bulk REST API failed: %1$s";
    }
    @Override
    public final SearchException elasticsearchFailedBecauseOfBulkFailure(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchFailedBecauseOfBulkFailure$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requestTimedOut$str() {
        return "HSEARCH400590: Request execution exceeded the timeout of %1$s. Request was %2$s";
    }
    @Override
    public final SearchTimeoutException requestTimedOut(final Duration timeout, final ElasticsearchRequest request) {
        final SearchTimeoutException result = new SearchTimeoutException(String.format(getLoggingLocale(), requestTimedOut$str(), new org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter(timeout), new ElasticsearchRequestFormatter(request)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchIndexNameAndAliasesMatchMultipleIndexes$str() {
        return "HSEARCH400593: Invalid Elasticsearch index layout: index names [%1$s, %2$s] resolve to multiple distinct indexes %3$s. These names must resolve to a single index.";
    }
    @Override
    public final SearchException elasticsearchIndexNameAndAliasesMatchMultipleIndexes(final URLEncodedString write, final URLEncodedString read, final Set<String> matchingIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchIndexNameAndAliasesMatchMultipleIndexes$str(), write, read, matchingIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexPrimaryName$str() {
        return "HSEARCH400594: Invalid Elasticsearch index layout: primary (non-alias) name for existing Elasticsearch index '%1$s' does not match the expected pattern '%2$s'.";
    }
    @Override
    public final SearchException invalidIndexPrimaryName(final String elasticsearchIndexName, final Pattern pattern) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexPrimaryName$str(), elasticsearchIndexName, pattern));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexUniqueKey$str() {
        return "HSEARCH400595: Invalid Elasticsearch index layout: unique key '%1$s' extracted from the index name does not match any of %2$s.";
    }
    @Override
    public final SearchException invalidIndexUniqueKey(final String uniqueKey, final Set<String> knownKeys) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexUniqueKey$str(), uniqueKey, knownKeys));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchAliasUpdateFailed$str() {
        return "HSEARCH400625: Unable to update aliases for index '%1$s': %2$s";
    }
    @Override
    public final SearchException elasticsearchAliasUpdateFailed(final Object indexName, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchAliasUpdateFailed$str(), indexName, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
