/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import java.util.List;
import java.util.Optional;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.client.sniff.NodesSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.client.sniff.SnifferBuilder;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.client.ElasticsearchHttpClientConfigurer;
import org.hibernate.search.backend.elasticsearch.client.impl.CustomConnectionKeepAliveStrategy;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientImpl;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchHttpClientConfigurationContextImpl;
import org.hibernate.search.backend.elasticsearch.client.impl.ServerUris;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientFactory;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientImplementor;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchClientLog;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.execution.spi.SimpleScheduledExecutor;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public class ElasticsearchClientFactoryImpl
implements ElasticsearchClientFactory {
    private static final OptionalConfigurationProperty<BeanReference<? extends RestClient>> CLIENT_INSTANCE = ConfigurationProperty.forKey((String)"client.instance").asBeanReference(RestClient.class).build();
    private static final OptionalConfigurationProperty<List<String>> HOSTS = ConfigurationProperty.forKey((String)"hosts").asString().multivalued().build();
    private static final OptionalConfigurationProperty<String> PROTOCOL = ConfigurationProperty.forKey((String)"protocol").asString().build();
    private static final OptionalConfigurationProperty<List<String>> URIS = ConfigurationProperty.forKey((String)"uris").asString().multivalued().build();
    private static final ConfigurationProperty<String> PATH_PREFIX = ConfigurationProperty.forKey((String)"path_prefix").asString().withDefault((Object)"").build();
    private static final OptionalConfigurationProperty<String> USERNAME = ConfigurationProperty.forKey((String)"username").asString().build();
    private static final OptionalConfigurationProperty<String> PASSWORD = ConfigurationProperty.forKey((String)"password").asString().build();
    private static final OptionalConfigurationProperty<Integer> REQUEST_TIMEOUT = ConfigurationProperty.forKey((String)"request_timeout").asIntegerStrictlyPositive().build();
    private static final ConfigurationProperty<Integer> READ_TIMEOUT = ConfigurationProperty.forKey((String)"read_timeout").asIntegerPositiveOrZeroOrNegative().withDefault((Object)30000).build();
    private static final ConfigurationProperty<Integer> CONNECTION_TIMEOUT = ConfigurationProperty.forKey((String)"connection_timeout").asIntegerPositiveOrZeroOrNegative().withDefault((Object)1000).build();
    private static final ConfigurationProperty<Integer> MAX_TOTAL_CONNECTION = ConfigurationProperty.forKey((String)"max_connections").asIntegerStrictlyPositive().withDefault((Object)40).build();
    private static final ConfigurationProperty<Integer> MAX_TOTAL_CONNECTION_PER_ROUTE = ConfigurationProperty.forKey((String)"max_connections_per_route").asIntegerStrictlyPositive().withDefault((Object)20).build();
    private static final ConfigurationProperty<Boolean> DISCOVERY_ENABLED = ConfigurationProperty.forKey((String)"discovery.enabled").asBoolean().withDefault((Object)false).build();
    private static final ConfigurationProperty<Integer> DISCOVERY_REFRESH_INTERVAL = ConfigurationProperty.forKey((String)"discovery.refresh_interval").asIntegerStrictlyPositive().withDefault((Object)10).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends ElasticsearchHttpClientConfigurer>> CLIENT_CONFIGURER = ConfigurationProperty.forKey((String)"client.configurer").asBeanReference(ElasticsearchHttpClientConfigurer.class).build();
    private static final OptionalConfigurationProperty<Long> MAX_KEEP_ALIVE = ConfigurationProperty.forKey((String)"max_keep_alive").asLongStrictlyPositive().build();

    @Override
    public ElasticsearchClientImplementor create(BeanResolver beanResolver, ConfigurationPropertySource propertySource, ThreadProvider threadProvider, String threadNamePrefix, SimpleScheduledExecutor timeoutExecutorService, GsonProvider gsonProvider, Optional<ElasticsearchVersion> configuredVersion) {
        Sniffer sniffer;
        BeanHolder<? extends RestClient> restClientHolder;
        Optional requestTimeoutMs = (Optional)REQUEST_TIMEOUT.get(propertySource);
        int connectionTimeoutMs = (Integer)CONNECTION_TIMEOUT.get(propertySource);
        Optional providedRestClientHolder = CLIENT_INSTANCE.getAndMap(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));
        if (providedRestClientHolder.isPresent()) {
            restClientHolder = (BeanHolder<? extends RestClient>)providedRestClientHolder.get();
            sniffer = null;
        } else {
            ServerUris hosts = ServerUris.fromOptionalStrings((Optional)PROTOCOL.get(propertySource), (Optional)HOSTS.get(propertySource), (Optional)URIS.get(propertySource));
            restClientHolder = this.createClient(beanResolver, propertySource, threadProvider, threadNamePrefix, configuredVersion, hosts, (String)PATH_PREFIX.get(propertySource));
            sniffer = this.createSniffer(propertySource, (RestClient)restClientHolder.get(), hosts);
        }
        return new ElasticsearchClientImpl(restClientHolder, sniffer, timeoutExecutorService, requestTimeoutMs, connectionTimeoutMs, gsonProvider.getGson(), gsonProvider.getLogHelper());
    }

    private BeanHolder<? extends RestClient> createClient(BeanResolver beanResolver, ConfigurationPropertySource propertySource, ThreadProvider threadProvider, String threadNamePrefix, Optional<ElasticsearchVersion> configuredVersion, ServerUris hosts, String pathPrefix) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts.asHostsArray());
        if (!pathPrefix.isEmpty()) {
            builder.setPathPrefix(pathPrefix);
        }
        Optional customConfig = CLIENT_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));
        RestClient client = null;
        List httpClientConfigurerReferences = beanResolver.allConfiguredForRole(ElasticsearchHttpClientConfigurer.class);
        try {
            BeanHolder beanHolder;
            block13: {
                BeanHolder httpClientConfigurersHolder = beanResolver.resolve(httpClientConfigurerReferences);
                try {
                    client = builder.setRequestConfigCallback(b -> this.customizeRequestConfig(b, propertySource)).setHttpClientConfigCallback(b -> this.customizeHttpClientConfig(b, beanResolver, propertySource, threadProvider, threadNamePrefix, configuredVersion, hosts, (Iterable)httpClientConfigurersHolder.get(), customConfig)).build();
                    beanHolder = BeanHolder.ofCloseable((AutoCloseable)client);
                    if (httpClientConfigurersHolder == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (httpClientConfigurersHolder != null) {
                            try {
                                httpClientConfigurersHolder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        new SuppressingCloser((Throwable)e).push(client);
                        throw e;
                    }
                }
                httpClientConfigurersHolder.close();
            }
            return beanHolder;
        }
        finally {
            if (customConfig.isPresent()) {
                ((BeanHolder)customConfig.get()).close();
            }
        }
    }

    private Sniffer createSniffer(ConfigurationPropertySource propertySource, RestClient client, ServerUris hosts) {
        boolean discoveryEnabled = (Boolean)DISCOVERY_ENABLED.get(propertySource);
        if (discoveryEnabled) {
            SnifferBuilder builder = Sniffer.builder((RestClient)client).setSniffIntervalMillis((Integer)DISCOVERY_REFRESH_INTERVAL.get(propertySource) * 1000);
            if (hosts.isSslEnabled()) {
                ElasticsearchNodesSniffer hostsSniffer = new ElasticsearchNodesSniffer(client, ElasticsearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, ElasticsearchNodesSniffer.Scheme.HTTPS);
                builder.setNodesSniffer((NodesSniffer)hostsSniffer);
            }
            return builder.build();
        }
        return null;
    }

    private HttpAsyncClientBuilder customizeHttpClientConfig(HttpAsyncClientBuilder builder, BeanResolver beanResolver, ConfigurationPropertySource propertySource, ThreadProvider threadProvider, String threadNamePrefix, Optional<ElasticsearchVersion> configuredVersion, ServerUris hosts, Iterable<ElasticsearchHttpClientConfigurer> configurers, Optional<? extends BeanHolder<? extends ElasticsearchHttpClientConfigurer>> customConfig) {
        Optional maxKeepAlive;
        Optional username;
        builder.setMaxConnTotal(((Integer)MAX_TOTAL_CONNECTION.get(propertySource)).intValue()).setMaxConnPerRoute(((Integer)MAX_TOTAL_CONNECTION_PER_ROUTE.get(propertySource)).intValue()).setThreadFactory(threadProvider.createThreadFactory(threadNamePrefix + " - Transport thread"));
        if (!hosts.isSslEnabled()) {
            builder.setSSLStrategy((SchemeIOSessionStrategy)NoopIOSessionStrategy.INSTANCE);
        }
        if ((username = (Optional)USERNAME.get(propertySource)).isPresent()) {
            Optional password = (Optional)PASSWORD.get(propertySource);
            if (password.isPresent() && !hosts.isSslEnabled()) {
                ElasticsearchClientLog.INSTANCE.usingPasswordOverHttp();
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials((String)username.get(), (String)password.orElse(null)));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        if ((maxKeepAlive = (Optional)MAX_KEEP_ALIVE.get(propertySource)).isPresent()) {
            builder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new CustomConnectionKeepAliveStrategy((Long)maxKeepAlive.get()));
        }
        ElasticsearchHttpClientConfigurationContextImpl clientConfigurationContext = new ElasticsearchHttpClientConfigurationContextImpl(beanResolver, propertySource, builder, configuredVersion);
        for (ElasticsearchHttpClientConfigurer configurer : configurers) {
            configurer.configure(clientConfigurationContext);
        }
        if (customConfig.isPresent()) {
            BeanHolder<? extends ElasticsearchHttpClientConfigurer> customConfigBeanHolder = customConfig.get();
            ((ElasticsearchHttpClientConfigurer)customConfigBeanHolder.get()).configure(clientConfigurationContext);
        }
        return builder;
    }

    private RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder builder, ConfigurationPropertySource propertySource) {
        return builder.setConnectionRequestTimeout(0).setSocketTimeout(((Integer)READ_TIMEOUT.get(propertySource)).intValue()).setConnectTimeout(((Integer)CONNECTION_TIMEOUT.get(propertySource)).intValue());
    }
}

