package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import java.util.Set;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import java.lang.String;
import org.hibernate.search.engine.backend.types.TermVector;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import java.lang.Integer;
import java.lang.Class;
import java.util.Arrays;
import org.hibernate.search.engine.backend.types.VectorSimilarity;

/**
 * Warning this class consists of generated code.
 */
public class MappingLog_$logger implements MappingLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MappingLog_$logger.class.getName();
    public MappingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String indexSchemaNodeNameConflict$str() {
        return "HSEARCH400520: Duplicate index field definition: '%1$s'. Index field names must be unique. Look for two property mappings with the same field name, or two indexed-embeddeds with prefixes that lead to conflicting index field names, or two custom bridges declaring index fields with the same name.";
    }
    @Override
    public final SearchException indexSchemaNodeNameConflict(final String name, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaNodeNameConflict$str(), name), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String conflictingIndexNames$str() {
        return "HSEARCH400530: Conflicting index names: Hibernate Search indexes '%1$s' and '%2$s' both target the Elasticsearch index name or alias '%3$s'";
    }
    @Override
    public final SearchException conflictingIndexNames(final String firstHibernateSearchIndexName, final String secondHibernateSearchIndexName, final String nameOrAlias) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingIndexNames$str(), firstHibernateSearchIndexName, secondHibernateSearchIndexName, nameOrAlias));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotGuessFieldType$str() {
        return "HSEARCH400545: No built-in index field type for class: '%1$s'.";
    }
    @Override
    public final SearchException cannotGuessFieldType(final Class<?> inputType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotGuessFieldType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(inputType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompleteFieldDefinition$str() {
        return "HSEARCH400554: Incomplete field definition. You must call toReference() to complete the field definition.";
    }
    @Override
    public final SearchException incompleteFieldDefinition(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incompleteFieldDefinition$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateReferenceMultipleTimes$str() {
        return "HSEARCH400555: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    }
    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCreateReferenceMultipleTimes$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullDecimalScale$str() {
        return "HSEARCH400567: Invalid index field type: missing decimal scale. Define the decimal scale explicitly.  %1$s";
    }
    @Override
    public final SearchException nullDecimalScale(final String hint, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullDecimalScale$str(), hint), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDecimalScale$str() {
        return "HSEARCH400570: Invalid index field type: decimal scale '%1$s' is positive. The decimal scale of BigInteger fields must be zero or negative.";
    }
    @Override
    public final SearchException invalidDecimalScale(final Integer decimalScale, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDecimalScale$str(), decimalScale), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sameWriteAndReadAliases$str() {
        return "HSEARCH400596: Invalid Elasticsearch index layout: the write alias and read alias are set to the same value: '%1$s'. The write alias and read alias must be different.";
    }
    @Override
    public final SearchException sameWriteAndReadAliases(final URLEncodedString writeAndReadAlias) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), sameWriteAndReadAliases$str(), writeAndReadAlias));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexSchemaFieldTemplateNameConflict$str() {
        return "HSEARCH400607: Duplicate index field template definition: '%1$s'. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }
    @Override
    public final SearchException indexSchemaFieldTemplateNameConflict(final String name, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaFieldTemplateNameConflict$str(), name), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customIndexSettingsFileNotFound$str() {
        return "HSEARCH400631: Unable to find the given custom index settings file: '%1$s'.";
    }
    @Override
    public final SearchException customIndexSettingsFileNotFound(final String filePath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), customIndexSettingsFileNotFound$str(), filePath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customIndexSettingsErrorOnLoading$str() {
        return "HSEARCH400632: Error on loading the given custom index settings file '%1$s': %2$s";
    }
    @Override
    public final SearchException customIndexSettingsErrorOnLoading(final String filePath, final String causeMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), customIndexSettingsErrorOnLoading$str(), filePath, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customIndexSettingsJsonSyntaxErrors$str() {
        return "HSEARCH400633: There are some JSON syntax errors on the given custom index settings file '%1$s': %2$s";
    }
    @Override
    public final SearchException customIndexSettingsJsonSyntaxErrors(final String filePath, final String causeMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), customIndexSettingsJsonSyntaxErrors$str(), filePath, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexSchemaNamedPredicateNameConflict$str() {
        return "HSEARCH400637: The index schema named predicate '%1$s' was added twice.";
    }
    @Override
    public final SearchException indexSchemaNamedPredicateNameConflict(final String relativeFilterName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaNamedPredicateNameConflict$str(), relativeFilterName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customIndexMappingFileNotFound$str() {
        return "HSEARCH400651: Unable to find the given custom index mapping file: '%1$s'.";
    }
    @Override
    public final SearchException customIndexMappingFileNotFound(final String filePath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), customIndexMappingFileNotFound$str(), filePath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customIndexMappingErrorOnLoading$str() {
        return "HSEARCH400652: Error on loading the given custom index mapping file '%1$s': %2$s";
    }
    @Override
    public final SearchException customIndexMappingErrorOnLoading(final String filePath, final String causeMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), customIndexMappingErrorOnLoading$str(), filePath, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customIndexMappingJsonSyntaxErrors$str() {
        return "HSEARCH400653: There are some JSON syntax errors on the given custom index mapping file '%1$s': %2$s";
    }
    @Override
    public final SearchException customIndexMappingJsonSyntaxErrors(final String filePath, final String causeMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), customIndexMappingJsonSyntaxErrors$str(), filePath, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedMixOfHighlightableValues$str() {
        return "HSEARCH400667: Cannot use 'NO' in combination with other highlightable values. Applied values are: '%1$s'";
    }
    @Override
    public final SearchException unsupportedMixOfHighlightableValues(final Set<org.hibernate.search.engine.backend.types.Highlightable> highlightable) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedMixOfHighlightableValues$str(), highlightable));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String termVectorDontAllowFastVectorHighlighter$str() {
        return "HSEARCH400668: The '%1$s' term vector storage strategy is not compatible with the fast vector highlighter. Either change the strategy to one of `WITH_POSITIONS_PAYLOADS`/`WITH_POSITIONS_OFFSETS_PAYLOADS` or remove the requirement for the fast vector highlighter support.";
    }
    @Override
    public final SearchException termVectorDontAllowFastVectorHighlighter(final TermVector termVector) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), termVectorDontAllowFastVectorHighlighter$str(), termVector));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noHighlightableProvided$str() {
        return "HSEARCH400669: Setting the `highlightable` attribute to an empty array is not supported. Set the value to `NO` if the field does not require the highlight projection.";
    }
    @Override
    public final SearchException noHighlightableProvided() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noHighlightableProvided$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotGuessVectorFieldType$str() {
        return "HSEARCH400678: No built-in vector index field type for class: '%1$s'.";
    }
    @Override
    public final SearchException cannotGuessVectorFieldType(final Class<?> inputType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotGuessVectorFieldType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(inputType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullVectorDimension$str() {
        return "HSEARCH400679: Invalid index field type: missing vector dimension. Define the vector dimension explicitly. %1$s";
    }
    @Override
    public final SearchException nullVectorDimension(final String hint, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullVectorDimension$str(), hint), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiValuedFieldNotAllowed$str() {
        return "HSEARCH400680: Fields of this type cannot be multivalued.";
    }
    @Override
    public final SearchException multiValuedFieldNotAllowed(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiValuedFieldNotAllowed$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorSimilarityNotSupportedByOpenSearchBackend$str() {
        return "HSEARCH400688: The OpenSearch distribution does not allow using %1$s as a space type for a Lucene engine. Try using a different similarity type and refer to the OpenSearch documentation for more details.";
    }
    @Override
    public final SearchException vectorSimilarityNotSupportedByOpenSearchBackend(final VectorSimilarity vectorSimilarity) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorSimilarityNotSupportedByOpenSearchBackend$str(), vectorSimilarity));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
