/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.Arrays;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionCompositor;

class ElasticsearchCompositeProjection<E, V, A, P>
extends AbstractElasticsearchProjection<P> {
    private final ElasticsearchSearchProjection<?>[] inners;
    private final ProjectionCompositor<E, V> compositor;
    private final ProjectionCollector<E, V, A, P> collector;

    public ElasticsearchCompositeProjection(Builder builder, ElasticsearchSearchProjection<?>[] inners, ProjectionCompositor<E, V> compositor, ProjectionCollector<E, V, A, P> collector) {
        super(builder.scope);
        this.inners = inners;
        this.compositor = compositor;
        this.collector = collector;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[inners=" + Arrays.toString(this.inners) + ", compositor=" + String.valueOf(this.compositor) + ", collector=" + String.valueOf(this.collector) + "]";
    }

    @Override
    public ElasticsearchSearchProjection.Extractor<A, P> request(JsonObject requestBody, ProjectionRequestContext context) {
        ElasticsearchSearchProjection.Extractor[] innerExtractors = new ElasticsearchSearchProjection.Extractor[this.inners.length];
        for (int i = 0; i < this.inners.length; ++i) {
            innerExtractors[i] = this.inners[i].request(requestBody, context);
        }
        return new CompositeExtractor(innerExtractors);
    }

    static class Builder
    implements CompositeProjectionBuilder {
        private final ElasticsearchSearchIndexScope<?> scope;

        Builder(ElasticsearchSearchIndexScope<?> scope) {
            this.scope = scope;
        }

        public <E, V, P> SearchProjection<P> build(SearchProjection<?>[] inners, ProjectionCompositor<E, V> compositor, ProjectionCollector.Provider<V, P> collectorProvider) {
            ElasticsearchSearchProjection[] typedInners = new ElasticsearchSearchProjection[inners.length];
            for (int i = 0; i < inners.length; ++i) {
                typedInners[i] = ElasticsearchSearchProjection.from(this.scope, inners[i]);
            }
            return new ElasticsearchCompositeProjection(this, typedInners, compositor, collectorProvider.get());
        }
    }

    private class CompositeExtractor
    implements ElasticsearchSearchProjection.Extractor<A, P> {
        private final ElasticsearchSearchProjection.Extractor<?, ?>[] inners;

        private CompositeExtractor(ElasticsearchSearchProjection.Extractor<?, ?>[] inners) {
            this.inners = inners;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[inners=" + Arrays.toString(this.inners) + ", compositor=" + String.valueOf(ElasticsearchCompositeProjection.this.compositor) + ", collector=" + String.valueOf(ElasticsearchCompositeProjection.this.collector) + "]";
        }

        @Override
        public A extract(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonObject source, ProjectionExtractContext context) {
            Object accumulated = ElasticsearchCompositeProjection.this.collector.createInitial();
            Object components = ElasticsearchCompositeProjection.this.compositor.createInitial();
            for (int i = 0; i < this.inners.length; ++i) {
                Object extractedDataForInner = this.inners[i].extract(projectionHitMapper, hit, source, context);
                components = ElasticsearchCompositeProjection.this.compositor.set(components, i, extractedDataForInner);
            }
            accumulated = ElasticsearchCompositeProjection.this.collector.accumulate(accumulated, components);
            return accumulated;
        }

        @Override
        public final P transform(LoadingResult<?> loadingResult, A accumulated, ProjectionTransformContext context) {
            for (int i = 0; i < ElasticsearchCompositeProjection.this.collector.size(accumulated); ++i) {
                Object transformedData = ElasticsearchCompositeProjection.this.collector.get(accumulated, i);
                for (int j = 0; j < this.inners.length; ++j) {
                    Object extractedDataForInner = ElasticsearchCompositeProjection.this.compositor.get(transformedData, j);
                    Object transformedDataForInner = ElasticsearchSearchProjection.Extractor.transformUnsafe(this.inners[j], loadingResult, extractedDataForInner, context);
                    transformedData = ElasticsearchCompositeProjection.this.compositor.set(transformedData, j, transformedDataForInner);
                }
                accumulated = ElasticsearchCompositeProjection.this.collector.transform(accumulated, i, ElasticsearchCompositeProjection.this.compositor.finish(transformedData));
            }
            return ElasticsearchCompositeProjection.this.collector.finish(accumulated);
        }
    }
}

