/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import java.util.Set;
import org.hibernate.search.backend.elasticsearch.logging.impl.QueryLog;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.impl.CollectionHelper;

public interface ElasticsearchSearchSort
extends SearchSort {
    public Set<String> indexNames();

    public void toJsonSorts(ElasticsearchSearchSortCollector var1);

    public static ElasticsearchSearchSort from(ElasticsearchSearchIndexScope<?> scope, SearchSort sort) {
        if (!(sort instanceof ElasticsearchSearchSort)) {
            throw QueryLog.INSTANCE.cannotMixElasticsearchSearchSortWithOtherSorts(sort);
        }
        ElasticsearchSearchSort casted = (ElasticsearchSearchSort)sort;
        if (!CollectionHelper.isSubset((Set)scope.hibernateSearchIndexNames(), casted.indexNames())) {
            throw QueryLog.INSTANCE.sortDefinedOnDifferentIndexes(sort, casted.indexNames(), scope.hibernateSearchIndexNames(), CollectionHelper.notInTheOtherSet((Set)scope.hibernateSearchIndexNames(), casted.indexNames()));
        }
        return casted;
    }
}

