package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.util.Locale;
import org.hibernate.search.util.common.reporting.EventContext;
import java.io.Serializable;
import org.hibernate.search.util.common.SearchException;
import java.lang.Object;
import java.lang.Class;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class ElasticsearchMiscLog_$logger implements ElasticsearchMiscLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElasticsearchMiscLog_$logger.class.getName();
    public ElasticsearchMiscLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String elasticsearchExtensionOnUnknownType$str() {
        return "HSEARCH400506: Invalid target for Elasticsearch extension: '%1$s'. This extension can only be applied to components created by an Elasticsearch backend.";
    }
    @Override
    public final SearchException elasticsearchExtensionOnUnknownType(final Object context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchExtensionOnUnknownType$str(), context));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String clientUnwrappingWithUnknownType$str() {
        return "HSEARCH400518: Invalid requested type for client: '%1$s'. The Elasticsearch low-level client can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException clientUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), clientUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH400519: Invalid requested type for this backend: '%1$s'. Elasticsearch backends can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException backendUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), backendUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH400533: Invalid requested type for this index manager: '%1$s'. Elasticsearch index managers can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexManagerUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToExportSchema$str() {
        return "HSEARCH400657: Unable to export the schema for '%1$s' index: %2$s";
    }
    @Override
    public final SearchException unableToExportSchema(final String indexName, final String message, final IOException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToExportSchema$str(), indexName, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotExecuteOperationOnAmazonOpenSearchServerless$str() {
        return "HSEARCH400676: Cannot execute '%s' because Amazon OpenSearch Serverless does not support this operation. Either avoid this operation or switch to another Elasticsearch/OpenSearch distribution.";
    }
    @Override
    public final SearchException cannotExecuteOperationOnAmazonOpenSearchServerless(final String operation) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotExecuteOperationOnAmazonOpenSearchServerless$str(), operation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotRequireIndexStatus$str() {
        return "HSEARCH400677: The targeted Elasticsearch cluster does not expose index status, so index status requirements cannot be enforced.";
    }
    @Override
    public final SearchException cannotRequireIndexStatus() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotRequireIndexStatus$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void normalizeIndexName(final String indexName, final String esIndexName) {
        log.logf(FQCN, DEBUG, null, normalizeIndexName$str(), indexName, esIndexName);
    }
    protected String normalizeIndexName$str() {
        return "HSEARCH400691: Normalizing index name from '%1$s' to '%2$s'";
    }
}
