/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchMiscLog;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;

public class ElasticsearchMiscLog_$logger
implements ElasticsearchMiscLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElasticsearchMiscLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public ElasticsearchMiscLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String elasticsearchExtensionOnUnknownType$str() {
        return "HSEARCH400506: Invalid target for Elasticsearch extension: '%1$s'. This extension can only be applied to components created by an Elasticsearch backend.";
    }

    @Override
    public final SearchException elasticsearchExtensionOnUnknownType(Object context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchExtensionOnUnknownType$str(), context));
        ElasticsearchMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String clientUnwrappingWithUnknownType$str() {
        return "HSEARCH400518: Invalid requested type for client: '%1$s'. The Elasticsearch low-level client can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException clientUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.clientUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)));
        ElasticsearchMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH400519: Invalid requested type for this backend: '%1$s'. Elasticsearch backends can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException backendUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        ElasticsearchMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH400533: Invalid requested type for this index manager: '%1$s'. Elasticsearch index managers can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexManagerUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        ElasticsearchMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToExportSchema$str() {
        return "HSEARCH400657: Unable to export the schema for '%1$s' index: %2$s";
    }

    @Override
    public final SearchException unableToExportSchema(String indexName, String message, IOException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToExportSchema$str(), indexName, message), (Throwable)e);
        ElasticsearchMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotExecuteOperationOnAmazonOpenSearchServerless$str() {
        return "HSEARCH400676: Cannot execute '%s' because Amazon OpenSearch Serverless does not support this operation. Either avoid this operation or switch to another Elasticsearch/OpenSearch distribution.";
    }

    @Override
    public final SearchException cannotExecuteOperationOnAmazonOpenSearchServerless(String operation) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotExecuteOperationOnAmazonOpenSearchServerless$str(), operation));
        ElasticsearchMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotRequireIndexStatus$str() {
        return "HSEARCH400677: The targeted Elasticsearch cluster does not expose index status, so index status requirements cannot be enforced.";
    }

    @Override
    public final SearchException cannotRequireIndexStatus() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotRequireIndexStatus$str(), new Object[0]));
        ElasticsearchMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void normalizeIndexName(String indexName, String esIndexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.normalizeIndexName$str(), (Object)indexName, (Object)esIndexName);
    }

    protected String normalizeIndexName$str() {
        return "HSEARCH400691: Normalizing index name from '%1$s' to '%2$s'";
    }
}

