/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.logging.impl.MappingLog;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.types.Highlightable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.backend.types.VectorSimilarity;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;

public class MappingLog_$logger
implements MappingLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MappingLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public MappingLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String indexSchemaNodeNameConflict$str() {
        return "HSEARCH400520: Duplicate index field definition: '%1$s'. Index field names must be unique. Look for two property mappings with the same field name, or two indexed-embeddeds with prefixes that lead to conflicting index field names, or two custom bridges declaring index fields with the same name.";
    }

    @Override
    public final SearchException indexSchemaNodeNameConflict(String name, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNodeNameConflict$str(), name), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String conflictingIndexNames$str() {
        return "HSEARCH400530: Conflicting index names: Hibernate Search indexes '%1$s' and '%2$s' both target the Elasticsearch index name or alias '%3$s'";
    }

    @Override
    public final SearchException conflictingIndexNames(String firstHibernateSearchIndexName, String secondHibernateSearchIndexName, String nameOrAlias) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingIndexNames$str(), firstHibernateSearchIndexName, secondHibernateSearchIndexName, nameOrAlias));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotGuessFieldType$str() {
        return "HSEARCH400545: No built-in index field type for class: '%1$s'.";
    }

    @Override
    public final SearchException cannotGuessFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessFieldType$str(), new ClassFormatter(inputType)), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String incompleteFieldDefinition$str() {
        return "HSEARCH400554: Incomplete field definition. You must call toReference() to complete the field definition.";
    }

    @Override
    public final SearchException incompleteFieldDefinition(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompleteFieldDefinition$str(), new Object[0]), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotCreateReferenceMultipleTimes$str() {
        return "HSEARCH400555: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    }

    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCreateReferenceMultipleTimes$str(), new Object[0]), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullDecimalScale$str() {
        return "HSEARCH400567: Invalid index field type: missing decimal scale. Define the decimal scale explicitly.  %1$s";
    }

    @Override
    public final SearchException nullDecimalScale(String hint, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullDecimalScale$str(), hint), eventContext);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidDecimalScale$str() {
        return "HSEARCH400570: Invalid index field type: decimal scale '%1$s' is positive. The decimal scale of BigInteger fields must be zero or negative.";
    }

    @Override
    public final SearchException invalidDecimalScale(Integer decimalScale, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDecimalScale$str(), decimalScale), eventContext);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String sameWriteAndReadAliases$str() {
        return "HSEARCH400596: Invalid Elasticsearch index layout: the write alias and read alias are set to the same value: '%1$s'. The write alias and read alias must be different.";
    }

    @Override
    public final SearchException sameWriteAndReadAliases(URLEncodedString writeAndReadAlias) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sameWriteAndReadAliases$str(), writeAndReadAlias));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexSchemaFieldTemplateNameConflict$str() {
        return "HSEARCH400607: Duplicate index field template definition: '%1$s'. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }

    @Override
    public final SearchException indexSchemaFieldTemplateNameConflict(String name, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaFieldTemplateNameConflict$str(), name), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String customIndexSettingsFileNotFound$str() {
        return "HSEARCH400631: Unable to find the given custom index settings file: '%1$s'.";
    }

    @Override
    public final SearchException customIndexSettingsFileNotFound(String filePath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.customIndexSettingsFileNotFound$str(), filePath), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String customIndexSettingsErrorOnLoading$str() {
        return "HSEARCH400632: Error on loading the given custom index settings file '%1$s': %2$s";
    }

    @Override
    public final SearchException customIndexSettingsErrorOnLoading(String filePath, String causeMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.customIndexSettingsErrorOnLoading$str(), filePath, causeMessage), (Throwable)cause, context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String customIndexSettingsJsonSyntaxErrors$str() {
        return "HSEARCH400633: There are some JSON syntax errors on the given custom index settings file '%1$s': %2$s";
    }

    @Override
    public final SearchException customIndexSettingsJsonSyntaxErrors(String filePath, String causeMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.customIndexSettingsJsonSyntaxErrors$str(), filePath, causeMessage), (Throwable)cause, context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexSchemaNamedPredicateNameConflict$str() {
        return "HSEARCH400637: The index schema named predicate '%1$s' was added twice.";
    }

    @Override
    public final SearchException indexSchemaNamedPredicateNameConflict(String relativeFilterName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNamedPredicateNameConflict$str(), relativeFilterName), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String customIndexMappingFileNotFound$str() {
        return "HSEARCH400651: Unable to find the given custom index mapping file: '%1$s'.";
    }

    @Override
    public final SearchException customIndexMappingFileNotFound(String filePath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.customIndexMappingFileNotFound$str(), filePath), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String customIndexMappingErrorOnLoading$str() {
        return "HSEARCH400652: Error on loading the given custom index mapping file '%1$s': %2$s";
    }

    @Override
    public final SearchException customIndexMappingErrorOnLoading(String filePath, String causeMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.customIndexMappingErrorOnLoading$str(), filePath, causeMessage), (Throwable)cause, context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String customIndexMappingJsonSyntaxErrors$str() {
        return "HSEARCH400653: There are some JSON syntax errors on the given custom index mapping file '%1$s': %2$s";
    }

    @Override
    public final SearchException customIndexMappingJsonSyntaxErrors(String filePath, String causeMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.customIndexMappingJsonSyntaxErrors$str(), filePath, causeMessage), (Throwable)cause, context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedMixOfHighlightableValues$str() {
        return "HSEARCH400667: Cannot use 'NO' in combination with other highlightable values. Applied values are: '%1$s'";
    }

    @Override
    public final SearchException unsupportedMixOfHighlightableValues(Set<Highlightable> highlightable) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedMixOfHighlightableValues$str(), highlightable));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String termVectorDontAllowFastVectorHighlighter$str() {
        return "HSEARCH400668: The '%1$s' term vector storage strategy is not compatible with the fast vector highlighter. Either change the strategy to one of `WITH_POSITIONS_PAYLOADS`/`WITH_POSITIONS_OFFSETS_PAYLOADS` or remove the requirement for the fast vector highlighter support.";
    }

    @Override
    public final SearchException termVectorDontAllowFastVectorHighlighter(TermVector termVector) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.termVectorDontAllowFastVectorHighlighter$str(), termVector));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noHighlightableProvided$str() {
        return "HSEARCH400669: Setting the `highlightable` attribute to an empty array is not supported. Set the value to `NO` if the field does not require the highlight projection.";
    }

    @Override
    public final SearchException noHighlightableProvided() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noHighlightableProvided$str(), new Object[0]));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotGuessVectorFieldType$str() {
        return "HSEARCH400678: No built-in vector index field type for class: '%1$s'.";
    }

    @Override
    public final SearchException cannotGuessVectorFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessVectorFieldType$str(), new ClassFormatter(inputType)), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullVectorDimension$str() {
        return "HSEARCH400679: Invalid index field type: missing vector dimension. Define the vector dimension explicitly. %1$s";
    }

    @Override
    public final SearchException nullVectorDimension(String hint, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullVectorDimension$str(), hint), eventContext);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiValuedFieldNotAllowed$str() {
        return "HSEARCH400680: Fields of this type cannot be multivalued.";
    }

    @Override
    public final SearchException multiValuedFieldNotAllowed(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiValuedFieldNotAllowed$str(), new Object[0]), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String vectorSimilarityNotSupportedByOpenSearchBackend$str() {
        return "HSEARCH400688: The OpenSearch distribution does not allow using %1$s as a space type for a Lucene engine. Try using a different similarity type and refer to the OpenSearch documentation for more details.";
    }

    @Override
    public final SearchException vectorSimilarityNotSupportedByOpenSearchBackend(VectorSimilarity vectorSimilarity) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.vectorSimilarityNotSupportedByOpenSearchBackend$str(), vectorSimilarity));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

