/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.QueryLog;
import org.hibernate.search.backend.elasticsearch.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.highlighter.impl.ElasticsearchSearchHighlighter;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DistanceSortKey;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchQuery;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchRequestTransformer;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryImpl;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryRequestContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultExtractorFactory;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.backend.elasticsearch.work.factory.impl.ElasticsearchWorkFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContext;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.query.spi.QueryParameters;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.impl.Contracts;

public class ElasticsearchSearchQueryBuilder<H>
implements SearchQueryBuilder<H>,
ElasticsearchSearchSortCollector {
    private static final JsonAccessor<JsonElement> REQUEST_SOURCE_ACCESSOR = JsonAccessor.root().property("_source");
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory;
    private final ElasticsearchParallelWorkOrchestrator queryOrchestrator;
    private final ElasticsearchSearchIndexScope<?> scope;
    private final BackendSessionContext sessionContext;
    private final PredicateRequestContext rootPredicateContext;
    private final SearchLoadingContextBuilder<?, ?> loadingContextBuilder;
    private final ElasticsearchSearchProjection<H> rootProjection;
    private final Integer scrollTimeout;
    private final Set<String> routingKeys;
    private ElasticsearchSearchPredicate elasticsearchPredicate;
    private JsonArray jsonSort;
    private List<ElasticsearchSearchSort> elasticsearchSearchSorts;
    private Map<DistanceSortKey, Integer> distanceSorts;
    private Map<AggregationKey<?>, ElasticsearchSearchAggregation<?>> aggregations;
    private Long timeoutValue;
    private TimeUnit timeoutUnit;
    private boolean exceptionOnTimeout;
    private Long totalHitCountThreshold;
    private ElasticsearchSearchHighlighter queryHighlighter;
    private final Map<String, ElasticsearchSearchHighlighter> namedHighlighters = new HashMap<String, ElasticsearchSearchHighlighter>();
    private final QueryParameters parameters = new QueryParameters();
    private ElasticsearchSearchRequestTransformer requestTransformer;

    public ElasticsearchSearchQueryBuilder(ElasticsearchWorkFactory workFactory, ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory, ElasticsearchParallelWorkOrchestrator queryOrchestrator, ElasticsearchSearchIndexScope<?> scope, BackendSessionContext sessionContext, SearchLoadingContextBuilder<?, ?> loadingContextBuilder, ElasticsearchSearchProjection<H> rootProjection, Integer scrollTimeout) {
        this.workFactory = workFactory;
        this.searchResultExtractorFactory = searchResultExtractorFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.scope = scope;
        this.sessionContext = sessionContext;
        this.routingKeys = new HashSet<String>();
        this.rootPredicateContext = new PredicateRequestContext(sessionContext, scope, this.routingKeys, this.parameters);
        this.loadingContextBuilder = loadingContextBuilder;
        this.rootProjection = rootProjection;
        this.scrollTimeout = scrollTimeout;
    }

    public void predicate(SearchPredicate predicate) {
        this.elasticsearchPredicate = ElasticsearchSearchPredicate.from(this.scope, predicate);
    }

    public void sort(SearchSort sort) {
        if (this.elasticsearchSearchSorts == null) {
            this.elasticsearchSearchSorts = new ArrayList<ElasticsearchSearchSort>();
        }
        this.elasticsearchSearchSorts.add(ElasticsearchSearchSort.from(this.scope, sort));
    }

    public <A> void aggregation(AggregationKey<A> key, SearchAggregation<A> aggregation) {
        ElasticsearchSearchAggregation<A> previous;
        ElasticsearchSearchAggregation<A> casted = ElasticsearchSearchAggregation.from(this.scope, aggregation);
        if (this.aggregations == null) {
            this.aggregations = new LinkedHashMap();
        }
        if ((previous = this.aggregations.put(key, casted)) != null) {
            throw QueryLog.INSTANCE.duplicateAggregationKey(key);
        }
    }

    public void addRoutingKey(String routingKey) {
        this.routingKeys.add(routingKey);
    }

    public void truncateAfter(long timeout, TimeUnit timeUnit) {
        this.timeoutValue = timeout;
        this.timeoutUnit = timeUnit;
        this.exceptionOnTimeout = false;
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeoutValue = timeout;
        this.timeoutUnit = timeUnit;
        this.exceptionOnTimeout = true;
    }

    public void totalHitCountThreshold(long totalHitCountThreshold) {
        this.totalHitCountThreshold = totalHitCountThreshold;
    }

    public void highlighter(SearchHighlighter queryHighlighter) {
        this.queryHighlighter = ElasticsearchSearchHighlighter.from(this.scope, queryHighlighter);
    }

    public void highlighter(String highlighterName, SearchHighlighter highlighter) {
        if (highlighterName == null || highlighterName.trim().isEmpty()) {
            throw QueryLog.INSTANCE.highlighterNameCannotBeBlank();
        }
        if (this.namedHighlighters.put(highlighterName, ElasticsearchSearchHighlighter.from(this.scope, highlighter)) != null) {
            throw QueryLog.INSTANCE.highlighterWithTheSameNameCannotBeAdded(highlighterName);
        }
    }

    public void param(String parameterName, Object value) {
        this.parameters.add(parameterName, value);
    }

    @Override
    public PredicateRequestContext getRootPredicateContext() {
        return this.rootPredicateContext;
    }

    @Override
    public void collectSort(JsonElement sort) {
        if (this.jsonSort == null) {
            this.jsonSort = new JsonArray();
        }
        this.jsonSort.add(sort);
    }

    @Override
    public void collectDistanceSort(JsonElement sort, String absoluteFieldPath, GeoPoint center) {
        this.collectSort(sort);
        int index = this.jsonSort.size() - 1;
        if (this.distanceSorts == null) {
            this.distanceSorts = CollectionHelper.newHashMap((int)3);
        }
        this.distanceSorts.put(new DistanceSortKey(absoluteFieldPath, center), index);
    }

    public void requestTransformer(ElasticsearchSearchRequestTransformer transformer) {
        Contracts.assertNotNull((Object)transformer, (String)"transformer");
        this.requestTransformer = transformer;
    }

    public ElasticsearchSearchQuery<H> build() {
        List<ElasticsearchSearchAggregation.Extractor<?>> aggregationExtractors;
        JsonObject payload = new JsonObject();
        SearchLoadingContext loadingContext = this.loadingContextBuilder.build();
        ElasticsearchSearchQueryRequestContext requestContext = new ElasticsearchSearchQueryRequestContext(this.scope, this.sessionContext, loadingContext, this.rootPredicateContext, this.distanceSorts, this.namedHighlighters, this.queryHighlighter, this.parameters);
        JsonArray filters = this.rootPredicateContext.tenantAndRoutingFilters();
        JsonObject jsonPredicate = this.elasticsearchPredicate.toJsonQuery(this.rootPredicateContext);
        JsonObject jsonQuery = Queries.boolFilter(jsonPredicate, filters);
        if (jsonQuery != null) {
            payload.add("query", (JsonElement)jsonQuery);
        }
        if (this.elasticsearchSearchSorts != null) {
            for (ElasticsearchSearchSort elasticsearchSearchSort : this.elasticsearchSearchSorts) {
                elasticsearchSearchSort.toJsonSorts(this);
            }
        }
        if (this.jsonSort != null) {
            payload.add("sort", (JsonElement)this.jsonSort);
        }
        ElasticsearchSearchProjection.Extractor<?, H> rootExtractor = this.rootProjection.request(payload, requestContext);
        if (this.aggregations != null) {
            aggregationExtractors = new ArrayList();
            JsonObject jsonAggregations = new JsonObject();
            for (Map.Entry<AggregationKey<?>, ElasticsearchSearchAggregation<?>> entry : this.aggregations.entrySet()) {
                aggregationExtractors.add(entry.getValue().request(requestContext, entry.getKey(), jsonAggregations));
            }
            payload.add("aggregations", (JsonElement)jsonAggregations);
        } else {
            aggregationExtractors = List.of();
        }
        if (this.queryHighlighter != null) {
            this.queryHighlighter.request(payload);
        }
        if (!REQUEST_SOURCE_ACCESSOR.get(payload).isPresent()) {
            REQUEST_SOURCE_ACCESSOR.set(payload, (JsonElement)new JsonPrimitive(Boolean.FALSE));
        }
        TimeoutManager timeoutManager = this.scope.createTimeoutManager(this.timeoutValue, this.timeoutUnit, this.exceptionOnTimeout);
        ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor = this.searchResultExtractorFactory.createResultExtractor(requestContext, rootExtractor, aggregationExtractors);
        return new ElasticsearchSearchQueryImpl<H>(this.workFactory, this.queryOrchestrator, this.scope, this.sessionContext, loadingContext, this.routingKeys, payload, this.requestTransformer, searchResultExtractor, timeoutManager, this.scrollTimeout, this.totalHitCountThreshold);
    }
}

