/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.logging.impl.QueryLog;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchNestableAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestBuildingContextContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexNodeContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.spi.CountValuesAggregationBuilder;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;

public class ElasticsearchCountValuesAggregation
extends AbstractElasticsearchNestableAggregation<Long> {
    private static final JsonAccessor<JsonObject> COUNT_PROPERTY_ACCESSOR = JsonAccessor.root().property("value_count").asObject();
    private static final JsonAccessor<JsonObject> COUNT_DISTINCT_PROPERTY_ACCESSOR = JsonAccessor.root().property("cardinality").asObject();
    private static final JsonAccessor<String> FIELD_PROPERTY_ACCESSOR = JsonAccessor.root().property("field").asString();
    private final String absoluteFieldPath;
    private final JsonAccessor<JsonObject> operation;

    private ElasticsearchCountValuesAggregation(Builder builder) {
        super(builder);
        this.absoluteFieldPath = builder.field.absolutePath();
        this.operation = builder.operation;
    }

    public static SearchQueryElementFactory<CountValuesAggregationBuilder.TypeSelector, ElasticsearchSearchIndexScope<?>, ElasticsearchSearchIndexNodeContext> factory() {
        return new Factory();
    }

    @Override
    protected final JsonObject doRequest(AggregationRequestBuildingContextContext context) {
        JsonObject outerObject = new JsonObject();
        JsonObject innerObject = new JsonObject();
        this.operation.set(outerObject, innerObject);
        FIELD_PROPERTY_ACCESSOR.set(innerObject, this.absoluteFieldPath);
        return outerObject;
    }

    @Override
    protected ElasticsearchSearchAggregation.Extractor<Long> extractor(AggregationKey<?> key, AggregationRequestBuildingContextContext context) {
        return new MetricLongExtractor(key, this.nestedPathHierarchy, this.filter);
    }

    private static class Builder
    extends AbstractElasticsearchNestableAggregation.AbstractBuilder<Long>
    implements CountValuesAggregationBuilder {
        private JsonAccessor<JsonObject> operation = COUNT_PROPERTY_ACCESSOR;

        private Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<?> field) {
            super(scope, field);
        }

        @Override
        public ElasticsearchCountValuesAggregation build() {
            return new ElasticsearchCountValuesAggregation(this);
        }

        public void distinct(boolean distinct) {
            this.operation = distinct ? COUNT_DISTINCT_PROPERTY_ACCESSOR : COUNT_PROPERTY_ACCESSOR;
        }
    }

    private static class Factory
    implements SearchQueryElementFactory<CountValuesAggregationBuilder.TypeSelector, ElasticsearchSearchIndexScope<?>, ElasticsearchSearchIndexNodeContext> {
        private Factory() {
        }

        public CountValuesAggregationBuilder.TypeSelector create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexNodeContext node) {
            return new TypeSelector(scope, node);
        }

        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            if (!this.getClass().equals(other.getClass())) {
                throw QueryLog.INSTANCE.differentImplementationClassForQueryElement(this.getClass(), other.getClass());
            }
        }
    }

    private static class MetricLongExtractor
    extends AbstractElasticsearchNestableAggregation.AbstractExtractor<Long> {
        protected MetricLongExtractor(AggregationKey<?> key, List<String> nestedPathHierarchy, ElasticsearchSearchPredicate filter) {
            super(key, nestedPathHierarchy, filter);
        }

        @Override
        protected Long doExtract(JsonObject aggregationResult, AggregationExtractContext context) {
            JsonElement value = aggregationResult.get("value");
            return JsonElementTypes.LONG.fromElement(value);
        }
    }

    private static final class TypeSelector
    implements CountValuesAggregationBuilder.TypeSelector {
        private final ElasticsearchSearchIndexScope<?> scope;
        private final ElasticsearchSearchIndexNodeContext node;

        private TypeSelector(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexNodeContext node) {
            this.scope = scope;
            this.node = node;
        }

        public CountValuesAggregationBuilder builder() {
            return new Builder(this.scope, (ElasticsearchSearchIndexValueFieldContext<?>)this.node.toValueField());
        }
    }
}

