/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.logging.impl.QueryLog;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchBucketAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestBuildingContextContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchCompositeAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchCountDocumentAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.spi.CountDocumentAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;
import org.hibernate.search.util.common.impl.CollectionHelper;

public class ElasticsearchRangeAggregation<F, K, V>
extends AbstractElasticsearchBucketAggregation<Range<K>, V> {
    private final String absoluteFieldPath;
    private final List<Range<K>> rangesInOrder;
    private final JsonArray rangesJson;
    private final ElasticsearchSearchAggregation<V> aggregation;

    private ElasticsearchRangeAggregation(Builder<F, K, V> builder) {
        super(builder);
        this.absoluteFieldPath = builder.field.absolutePath();
        this.rangesInOrder = builder.rangesInOrder;
        this.rangesJson = builder.rangesJson;
        this.aggregation = builder.aggregation;
    }

    @Override
    protected void doRequest(JsonObject outerObject, JsonObject innerObject, AggregationRequestBuildingContextContext context) {
        JsonObject rangeDefinition = new JsonObject();
        outerObject.add("range", (JsonElement)rangeDefinition);
        rangeDefinition.addProperty("field", this.absoluteFieldPath);
        rangeDefinition.addProperty("keyed", Boolean.valueOf(true));
        rangeDefinition.add("ranges", (JsonElement)this.rangesJson);
        context.add(AggregationRequestBuildingContextContext.buildingContextKey("innerExtractor"), this.aggregation.request(context, ElasticsearchCompositeAggregation.compositeKeyFor(this.isNested()), innerObject));
    }

    @Override
    protected ElasticsearchSearchAggregation.Extractor<Map<Range<K>, V>> extractor(AggregationKey<?> key, AggregationRequestBuildingContextContext context) {
        ElasticsearchSearchAggregation.Extractor innerExtractor = (ElasticsearchSearchAggregation.Extractor)context.get(AggregationRequestBuildingContextContext.buildingContextKey("innerExtractor"));
        return new RangeBucketExtractor(key, this.nestedPathHierarchy, this.filter, this.rangesInOrder, innerExtractor);
    }

    private static class Builder<F, K, T>
    extends AbstractElasticsearchBucketAggregation.AbstractBuilder<Range<K>, T>
    implements RangeAggregationBuilder<K, T> {
        private final Function<? super K, JsonElement> encoder;
        private final List<Range<K>> rangesInOrder;
        private final JsonArray rangesJson;
        private final ElasticsearchSearchAggregation<T> aggregation;

        protected Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<?> field, Function<? super K, JsonElement> encoder, List<Range<K>> rangesInOrder, JsonArray rangesJson, ElasticsearchSearchAggregation<T> aggregation) {
            super(scope, field);
            this.encoder = encoder;
            this.rangesInOrder = rangesInOrder;
            this.rangesJson = rangesJson;
            this.aggregation = aggregation;
        }

        public void range(Range<? extends K> range) {
            Optional upperBoundValue;
            JsonObject rangeJson = new JsonObject();
            Optional lowerBoundValue = range.lowerBoundValue();
            if (lowerBoundValue.isPresent()) {
                if (!RangeBoundInclusion.INCLUDED.equals((Object)range.lowerBoundInclusion())) {
                    throw QueryLog.INSTANCE.elasticsearchRangeAggregationRequiresCanonicalFormForRanges(range);
                }
                rangeJson.add("from", this.encoder.apply(lowerBoundValue.get()));
            }
            if ((upperBoundValue = range.upperBoundValue()).isPresent()) {
                if (!RangeBoundInclusion.EXCLUDED.equals((Object)range.upperBoundInclusion())) {
                    throw QueryLog.INSTANCE.elasticsearchRangeAggregationRequiresCanonicalFormForRanges(range);
                }
                rangeJson.add("to", this.encoder.apply(upperBoundValue.get()));
            }
            rangeJson.addProperty("key", String.valueOf(this.rangesJson.size()));
            this.rangesInOrder.add(range.map(Function.identity()));
            this.rangesJson.add((JsonElement)rangeJson);
        }

        public <N> Builder<F, K, N> withValue(SearchAggregation<N> aggregation) {
            return new Builder<F, K, N>(this.scope, this.field, this.encoder, this.rangesInOrder, this.rangesJson, ElasticsearchSearchAggregation.from(this.scope, aggregation));
        }

        @Override
        public ElasticsearchRangeAggregation<F, K, T> build() {
            return new ElasticsearchRangeAggregation(this);
        }
    }

    protected class RangeBucketExtractor
    extends AbstractElasticsearchBucketAggregation.AbstractBucketExtractor<Range<K>, V> {
        private final List<Range<K>> rangesInOrder;
        private final ElasticsearchSearchAggregation.Extractor<V> innerExtractor;

        protected RangeBucketExtractor(AggregationKey<?> key, List<String> nestedPathHierarchy, ElasticsearchSearchPredicate filter, List<Range<K>> rangesInOrder, ElasticsearchSearchAggregation.Extractor<V> innerExtractor) {
            super(key, nestedPathHierarchy, filter);
            this.rangesInOrder = rangesInOrder;
            this.innerExtractor = innerExtractor;
        }

        @Override
        protected Map<Range<K>, V> doExtract(AggregationExtractContext context, JsonElement buckets) {
            JsonObject bucketMap = buckets.getAsJsonObject();
            LinkedHashMap result = CollectionHelper.newLinkedHashMap((int)this.rangesInOrder.size());
            for (int i = 0; i < this.rangesInOrder.size(); ++i) {
                JsonObject bucket = bucketMap.get(String.valueOf(i)).getAsJsonObject();
                Range range = this.rangesInOrder.get(i);
                result.put(range, this.innerExtractor.extract(bucket, context));
            }
            return result;
        }
    }

    private static class CountBuilder<F, K>
    extends Builder<F, K, Long> {
        protected CountBuilder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<?> field, Function<? super K, JsonElement> encoder) {
            super(scope, field, encoder, new ArrayList(), new JsonArray(), ElasticsearchSearchAggregation.from(scope, ((CountDocumentAggregationBuilder.TypeSelector)ElasticsearchCountDocumentAggregation.factory().create(scope, field)).builder().build()));
        }
    }

    private static class TypeSelector<F>
    implements RangeAggregationBuilder.TypeSelector {
        private final ElasticsearchSearchIndexScope<?> scope;
        private final ElasticsearchSearchIndexValueFieldContext<F> field;

        private TypeSelector(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            this.scope = scope;
            this.field = field;
        }

        public <T> Builder<F, T, Long> type(Class<T> expectedType, ValueModel valueModel) {
            return new CountBuilder(this.scope, this.field, this.field.encodingContext().encoder(this.scope, this.field, expectedType, valueModel));
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchCodecAwareSearchQueryElementFactory<RangeAggregationBuilder.TypeSelector, F> {
        public Factory(ElasticsearchFieldCodec<F> codec) {
            super(codec);
        }

        @Override
        public RangeAggregationBuilder.TypeSelector create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            return new TypeSelector<F>(scope, field);
        }
    }
}

