/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.elasticsearch.ElasticsearchBackend;
import org.hibernate.search.backend.elasticsearch.analysis.impl.ElasticsearchAnalysisPerformer;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexScopeBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.elasticsearch.logging.impl.DeprecationLog;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchMiscLog;
import org.hibernate.search.backend.elasticsearch.logging.impl.QueryLog;
import org.hibernate.search.backend.elasticsearch.metamodel.ElasticsearchIndexDescriptor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchBatchingWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchIndexSchemaManager;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.engine.backend.analysis.AnalysisToken;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.backend.schema.management.spi.IndexSchemaManager;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchIndexManagerImpl
implements IndexManagerImplementor,
ElasticsearchIndexManager,
WorkExecutionIndexManagerContext {
    private static final OptionalConfigurationProperty<String> OBSOLETE_LIFECYCLE_STRATEGY = ConfigurationProperty.forKey((String)"lifecycle.strategy").asString().build();
    private final IndexManagerBackendContext backendContext;
    private final List<DocumentMetadataContributor> documentMetadataContributors;
    private final ElasticsearchBatchingWorkOrchestrator indexingOrchestrator;
    private final ElasticsearchIndexModel model;
    private ElasticsearchIndexSchemaManager schemaManager;
    private ElasticsearchAnalysisPerformer analysisPerformer;

    ElasticsearchIndexManagerImpl(IndexManagerBackendContext backendContext, ElasticsearchIndexModel model, List<DocumentMetadataContributor> documentMetadataContributors) {
        this.backendContext = backendContext;
        this.model = model;
        this.documentMetadataContributors = documentMetadataContributors;
        this.indexingOrchestrator = backendContext.createIndexingOrchestrator(model.hibernateSearchIndexName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "hibernateSearchName=" + this.model.hibernateSearchIndexName() + "]";
    }

    public void start(IndexManagerStartContext context) {
        try {
            this.model.onStart(this.backendContext);
            this.schemaManager = this.backendContext.createSchemaManager(this.model, context.configurationPropertySource());
            OBSOLETE_LIFECYCLE_STRATEGY.getAndMap(context.configurationPropertySource(), ignored -> {
                throw DeprecationLog.INSTANCE.lifecycleStrategyMovedToMapper();
            });
            this.indexingOrchestrator.start(context.configurationPropertySource());
            this.analysisPerformer = this.backendContext.createAnalysisPerformer(this.model);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(AbstractWorkOrchestrator::stop, (Object)this.indexingOrchestrator);
            throw e;
        }
    }

    public CompletableFuture<?> preStop() {
        return this.indexingOrchestrator.preStop();
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.push(AbstractWorkOrchestrator::stop, (Object)this.indexingOrchestrator);
            this.schemaManager = null;
        }
    }

    @Override
    public String getMappedTypeName() {
        return this.model.mappedTypeName();
    }

    @Override
    public URLEncodedString getElasticsearchIndexWriteName() {
        return this.model.names().write();
    }

    @Override
    public String toElasticsearchId(String tenantId, String id) {
        return this.backendContext.toElasticsearchId(tenantId, id);
    }

    @Override
    public JsonObject createDocument(String tenantId, String id, DocumentContributor documentContributor) {
        ElasticsearchDocumentObjectBuilder builder = new ElasticsearchDocumentObjectBuilder(this.model);
        documentContributor.contribute((DocumentElement)builder);
        JsonObject document = builder.build();
        for (DocumentMetadataContributor contributor : this.documentMetadataContributors) {
            contributor.contribute(document, tenantId, id);
        }
        return document;
    }

    public ElasticsearchIndexModel model() {
        return this.model;
    }

    public IndexSchemaManager schemaManager() {
        return this.schemaManager;
    }

    public IndexIndexingPlan createIndexingPlan(BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.backendContext.createIndexingPlan(this.indexingOrchestrator, this, sessionContext, refreshStrategy);
    }

    public IndexIndexer createIndexer(BackendSessionContext sessionContext) {
        return this.backendContext.createIndexer(this.indexingOrchestrator, this, sessionContext);
    }

    public IndexWorkspace createWorkspace(BackendMappingContext mappingContext, Set<String> tenantIds) {
        return this.backendContext.createWorkspace(this, tenantIds);
    }

    public <SR> IndexScopeBuilder<SR> createScopeBuilder(BackendMappingContext mappingContext, Class<SR> rootScopeType) {
        return new ElasticsearchIndexScopeBuilder<SR>(this.backendContext, mappingContext, rootScopeType, this);
    }

    public void addTo(IndexScopeBuilder<?> builder) {
        if (!(builder instanceof ElasticsearchIndexScopeBuilder)) {
            throw QueryLog.INSTANCE.cannotMixElasticsearchScopeWithOtherType(builder, this, this.backendContext.getEventContext());
        }
        ElasticsearchIndexScopeBuilder esBuilder = (ElasticsearchIndexScopeBuilder)builder;
        esBuilder.add(this.backendContext, this);
    }

    public IndexManager toAPI() {
        return this;
    }

    @Override
    public ElasticsearchBackend backend() {
        return this.backendContext.toAPI();
    }

    @Override
    public ElasticsearchIndexDescriptor descriptor() {
        return this.model;
    }

    public List<? extends AnalysisToken> analyze(String analyzerName, String terms) {
        return (List)Futures.unwrappedExceptionJoin(this.analyzeAsync(analyzerName, terms, OperationSubmitter.blocking()).toCompletableFuture());
    }

    public AnalysisToken normalize(String normalizerName, String terms) {
        return (AnalysisToken)Futures.unwrappedExceptionJoin(this.normalizeAsync(normalizerName, terms, OperationSubmitter.blocking()).toCompletableFuture());
    }

    public CompletionStage<List<? extends AnalysisToken>> analyzeAsync(String analyzerName, String terms, OperationSubmitter operationSubmitter) {
        return this.analysisPerformer.analyze(analyzerName, terms, operationSubmitter);
    }

    public CompletionStage<AnalysisToken> normalizeAsync(String normalizerName, String terms, OperationSubmitter operationSubmitter) {
        return this.analysisPerformer.normalize(normalizerName, terms, operationSubmitter);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchIndexManager.class)) {
            return (T)this;
        }
        throw ElasticsearchMiscLog.INSTANCE.indexManagerUnwrappingWithUnknownType(clazz, ElasticsearchIndexManager.class, this.getBackendAndIndexEventContext());
    }

    private EventContext getBackendAndIndexEventContext() {
        return this.backendContext.getEventContext().append(EventContexts.fromIndexName((String)this.model.hibernateSearchName()));
    }
}

