package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.util.Locale;
import org.hibernate.search.util.common.reporting.EventContext;
import java.io.Serializable;
import java.lang.Number;
import org.hibernate.search.util.common.SearchException;
import java.lang.Class;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.Exception;

/**
 * Warning this class consists of generated code.
 */
public class IndexingLog_$logger implements IndexingLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = IndexingLog_$logger.class.getName();
    public IndexingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String cannotConvertDslParameter$str() {
        return "HSEARCH400532: Unable to convert DSL argument: %1$s";
    }
    @Override
    public final SearchException cannotConvertDslParameter(final String errorMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotConvertDslParameter$str(), errorMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String multipleValuesForSingleValuedField$str() {
        return "HSEARCH400563: Multiple values assigned to field '%1$s': this field is single-valued. Declare the field as multi-valued in order to allow this.";
    }
    @Override
    public final SearchException multipleValuesForSingleValuedField(final String absolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleValuesForSingleValuedField$str(), absolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String scaledNumberTooLarge$str() {
        return "HSEARCH400569: Unable to encode value '%1$s': this field type only supports values ranging from '%2$s' to '%3$s'. If you want to encode values that are outside this range, change the decimal scale for this field. Do not forget to reindex all your data after changing the decimal scale.";
    }
    @Override
    public final SearchException scaledNumberTooLarge(final Number value, final Number min, final Number max) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), scaledNumberTooLarge$str(), value, min, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldValueType$str() {
        return "HSEARCH400608: Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldValueType(final Class<?> fieldValueType, final Class<?> invalidValueType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldValueType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(fieldValueType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(invalidValueType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownFieldForIndexing$str() {
        return "HSEARCH400609: Unknown field '%1$s'.";
    }
    @Override
    public final SearchException unknownFieldForIndexing(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForIndexing$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
