/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.analysis.elasticsearch")
@MessageLogger(projectCode="HSEARCH")
public interface AnalysisLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.analysis.elasticsearch";
    public static final AnalysisLog INSTANCE = (AnalysisLog)LoggerFactory.make(AnalysisLog.class, (String)"org.hibernate.search.analysis.elasticsearch", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=400055, value="Duplicate tokenizer definitions: '%1$s'. Tokenizer names must be unique.")
    public SearchException tokenizerNamingConflict(String var1);

    @Message(id=400056, value="Duplicate char filter definitions: '%1$s'. Char filter names must be unique.")
    public SearchException charFilterNamingConflict(String var1);

    @Message(id=400057, value="Duplicate token filter definitions: '%1$s'. Token filter names must be unique.")
    public SearchException tokenFilterNamingConflict(String var1);

    @Message(id=400075, value="Unable to apply analysis configuration: %1$s")
    public SearchException unableToApplyAnalysisConfiguration(String var1, @Cause Exception var2, @Param EventContext var3);

    @Message(id=400076, value="Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.")
    public SearchException invalidElasticsearchAnalyzerDefinition(String var1);

    @Message(id=400077, value="Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.")
    public SearchException invalidElasticsearchTokenizerDefinition(String var1);

    @Message(id=400078, value="Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.")
    public SearchException invalidElasticsearchCharFilterDefinition(String var1);

    @Message(id=400079, value="Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.")
    public SearchException invalidElasticsearchTokenFilterDefinition(String var1);

    @Message(id=400534, value="Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.")
    public SearchException invalidElasticsearchTypedAnalyzerDefinition(String var1);

    @Message(id=400535, value="Invalid index field type: both analyzer '%1$s' and normalizer '%2$s' are assigned to this type. Either an analyzer or a normalizer can be assigned, but not both.")
    public SearchException cannotApplyAnalyzerAndNormalizer(String var1, String var2, @Param EventContext var3);

    @Message(id=400536, value="Invalid index field type: both analyzer '%1$s' and sorts are enabled. Sorts are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.")
    public SearchException cannotUseAnalyzerOnSortableField(String var1, @Param EventContext var2);

    @Message(id=400537, value="Ambiguous value for parameter '%1$s': this parameter is set to two different values '%2$s' and '%3$s'.")
    public SearchException analysisComponentParameterConflict(String var1, JsonElement var2, JsonElement var3);

    @Message(id=400560, value="Cannot skip analysis on field '%1$s': the Elasticsearch backend will always normalize arguments before attempting matches on normalized fields.")
    public SearchException skipAnalysisOnNormalizedField(String var1, @Param EventContext var2);

    @Message(id=400562, value="Invalid index field type: both null token '%2$s' ('indexNullAs') and analyzer '%1$s' are assigned to this type. 'indexNullAs' is not supported on analyzed fields.")
    public SearchException cannotUseIndexNullAsAndAnalyzer(String var1, String var2, @Param EventContext var3);

    @Message(id=400576, value="Invalid index field type: both analyzer '%1$s' and aggregations are enabled. Aggregations are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.")
    public SearchException cannotUseAnalyzerOnAggregableField(String var1, @Param EventContext var2);

    @Message(id=400587, value="Invalid index field type: search analyzer '%1$s' is assigned to this type, but the indexing analyzer is missing. Assign an indexing analyzer and a search analyzer, or remove the search analyzer.")
    public SearchException searchAnalyzerWithoutAnalyzer(String var1, @Param EventContext var2);
}

