/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchBucketAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestBuildingContextContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchCompositeAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchCountDocumentAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.spi.CountDocumentAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.util.common.impl.CollectionHelper;

public class ElasticsearchTermsAggregation<F, K, T, V>
extends AbstractElasticsearchBucketAggregation<K, V> {
    private final String absoluteFieldPath;
    private final ProjectionConverter<T, ? extends K> fromFieldValueConverter;
    private final BiFunction<JsonElement, JsonElement, T> decodeFunction;
    private final ElasticsearchSearchAggregation<V> aggregation;
    private final JsonObject order;
    private final int size;
    private final int minDocCount;

    private ElasticsearchTermsAggregation(Builder<F, K, T, V> builder) {
        super(builder);
        this.absoluteFieldPath = builder.field.absolutePath();
        this.fromFieldValueConverter = builder.fromFieldValueConverter;
        this.decodeFunction = builder.decodeFunction;
        this.order = builder.order;
        this.size = builder.size;
        this.minDocCount = builder.minDocCount;
        this.aggregation = builder.aggregation;
    }

    @Override
    protected void doRequest(JsonObject outerObject, JsonObject innerObject, AggregationRequestBuildingContextContext context) {
        JsonObject termsDefinition = new JsonObject();
        outerObject.add("terms", (JsonElement)termsDefinition);
        termsDefinition.addProperty("field", this.absoluteFieldPath);
        if (this.order != null) {
            termsDefinition.add("order", (JsonElement)this.order);
        }
        termsDefinition.addProperty("size", (Number)this.size);
        termsDefinition.addProperty("min_doc_count", (Number)this.minDocCount);
        context.add(AggregationRequestBuildingContextContext.buildingContextKey("innerExtractor"), this.aggregation.request(context, ElasticsearchCompositeAggregation.compositeKeyFor(this.isNested()), innerObject));
    }

    @Override
    protected ElasticsearchSearchAggregation.Extractor<Map<K, V>> extractor(AggregationKey<?> key, AggregationRequestBuildingContextContext context) {
        ElasticsearchSearchAggregation.Extractor innerExtractor = (ElasticsearchSearchAggregation.Extractor)context.get(AggregationRequestBuildingContextContext.buildingContextKey("innerExtractor"));
        return new TermsBucketExtractor(key, this.nestedPathHierarchy, this.filter, innerExtractor);
    }

    private static class Builder<F, K, T, V>
    extends AbstractElasticsearchBucketAggregation.AbstractBuilder<K, V>
    implements TermsAggregationBuilder<K, V> {
        private final BiFunction<JsonElement, JsonElement, T> decodeFunction;
        private final ProjectionConverter<T, ? extends K> fromFieldValueConverter;
        private final ElasticsearchSearchAggregation<V> aggregation;
        private JsonObject order;
        private int minDocCount;
        private int size;

        private Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field, BiFunction<JsonElement, JsonElement, T> decodeFunction, ProjectionConverter<T, ? extends K> fromFieldValueConverter, ElasticsearchSearchAggregation<V> aggregation) {
            this(scope, field, decodeFunction, fromFieldValueConverter, aggregation, null, 1, 100);
        }

        public Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<?> field, BiFunction<JsonElement, JsonElement, T> decodeFunction, ProjectionConverter<T, ? extends K> fromFieldValueConverter, ElasticsearchSearchAggregation<V> aggregation, JsonObject order, int minDocCount, int size) {
            super(scope, field);
            this.order = order;
            this.decodeFunction = decodeFunction;
            this.fromFieldValueConverter = fromFieldValueConverter;
            this.aggregation = aggregation;
            this.minDocCount = minDocCount;
            this.size = size;
        }

        public void orderByCountDescending() {
            this.order("_count", "desc");
        }

        public void orderByCountAscending() {
            this.order("_count", "asc");
        }

        public void orderByTermAscending() {
            this.order(this.scope.searchSyntax().getTermAggregationOrderByTermToken(), "asc");
        }

        public void orderByTermDescending() {
            this.order(this.scope.searchSyntax().getTermAggregationOrderByTermToken(), "desc");
        }

        public void minDocumentCount(int minDocumentCount) {
            this.minDocCount = minDocumentCount;
        }

        public void maxTermCount(int maxTermCount) {
            this.size = maxTermCount;
        }

        public <R> TermsAggregationBuilder<K, R> withValue(SearchAggregation<R> aggregation) {
            return new Builder<F, K, T, R>(this.scope, this.field, this.decodeFunction, this.fromFieldValueConverter, ElasticsearchSearchAggregation.from(this.scope, aggregation), this.order, this.minDocCount, this.size);
        }

        @Override
        public ElasticsearchTermsAggregation<F, K, T, V> build() {
            return new ElasticsearchTermsAggregation(this);
        }

        protected final void order(String key, String order) {
            JsonObject orderObject = new JsonObject();
            orderObject.addProperty(key, order);
            this.order = orderObject;
        }
    }

    protected class TermsBucketExtractor
    extends AbstractElasticsearchBucketAggregation.AbstractBucketExtractor<K, V> {
        private final ElasticsearchSearchAggregation.Extractor<V> innerExtractor;

        protected TermsBucketExtractor(AggregationKey<?> key, List<String> nestedPathHierarchy, ElasticsearchSearchPredicate filter, ElasticsearchSearchAggregation.Extractor<V> innerExtractor) {
            super(key, nestedPathHierarchy, filter);
            this.innerExtractor = innerExtractor;
        }

        @Override
        protected Map<K, V> doExtract(AggregationExtractContext context, JsonElement buckets) {
            JsonArray bucketArray = buckets.getAsJsonArray();
            LinkedHashMap result = CollectionHelper.newLinkedHashMap((int)bucketArray.size());
            FromDocumentValueConvertContext convertContext = context.fromDocumentValueConvertContext();
            for (JsonElement bucketElement : bucketArray) {
                JsonObject bucket = bucketElement.getAsJsonObject();
                JsonElement keyJson = bucket.get("key");
                JsonElement keyAsStringJson = bucket.get("key_as_string");
                Object key = ElasticsearchTermsAggregation.this.fromFieldValueConverter.fromDocumentValue(ElasticsearchTermsAggregation.this.decodeFunction.apply(keyJson, keyAsStringJson), convertContext);
                result.put(key, this.innerExtractor.extract(bucket, context));
            }
            return result;
        }
    }

    private static class CountBuilder<F, K, T>
    extends Builder<F, K, T, Long> {
        protected CountBuilder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field, BiFunction<JsonElement, JsonElement, T> decodeFunction, ProjectionConverter<T, ? extends K> fromFieldValueConverter) {
            super(scope, field, decodeFunction, fromFieldValueConverter, ElasticsearchSearchAggregation.from(scope, ((CountDocumentAggregationBuilder.TypeSelector)ElasticsearchCountDocumentAggregation.factory().create(scope, field)).builder().build()));
        }
    }

    private static class TypeSelector<F>
    implements TermsAggregationBuilder.TypeSelector {
        private final ElasticsearchFieldCodec<F> codec;
        private final ElasticsearchSearchIndexScope<?> scope;
        private final ElasticsearchSearchIndexValueFieldContext<F> field;

        private TypeSelector(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            this.codec = codec;
            this.scope = scope;
            this.field = field;
        }

        public <T> Builder<F, T, ?, Long> type(Class<T> expectedType, ValueModel valueModel) {
            if (ValueModel.RAW.equals((Object)valueModel)) {
                return new CountBuilder(this.scope, this.field, (key, string) -> string != null && !string.isJsonNull() ? string : key, this.field.type().rawProjectionConverter().withConvertedType(expectedType, this.field));
            }
            return new CountBuilder(this.scope, this.field, this.codec::decodeAggregationKey, this.field.type().projectionConverter(valueModel).withConvertedType(expectedType, this.field));
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchCodecAwareSearchQueryElementFactory<TermsAggregationBuilder.TypeSelector, F> {
        public Factory(ElasticsearchFieldCodec<F> codec) {
            super(codec);
        }

        @Override
        public TermsAggregationBuilder.TypeSelector create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            return new TypeSelector<F>(this.codec, scope, field);
        }
    }
}

