/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.schema.management.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchClientLog;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.aliases.impl.IndexAliasDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.factory.impl.ElasticsearchWorkFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.CloseIndexWork;
import org.hibernate.search.backend.elasticsearch.work.impl.CreateIndexWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DropIndexWork;
import org.hibernate.search.backend.elasticsearch.work.impl.GetIndexMetadataWork;
import org.hibernate.search.backend.elasticsearch.work.impl.NonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.OpenIndexWork;
import org.hibernate.search.backend.elasticsearch.work.impl.PutIndexAliasesWork;
import org.hibernate.search.backend.elasticsearch.work.impl.PutIndexMappingWork;
import org.hibernate.search.backend.elasticsearch.work.impl.PutIndexSettingsWork;
import org.hibernate.search.backend.elasticsearch.work.impl.WaitForIndexStatusWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.CreateIndexResult;
import org.hibernate.search.backend.elasticsearch.work.result.impl.ExistingIndexMetadata;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;

final class ElasticsearchSchemaAccessor {
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchParallelWorkOrchestrator orchestrator;

    public ElasticsearchSchemaAccessor(ElasticsearchWorkFactory workFactory, ElasticsearchParallelWorkOrchestrator orchestrator) {
        this.workFactory = workFactory;
        this.orchestrator = orchestrator;
    }

    public CompletableFuture<?> createIndexAssumeNonExisting(URLEncodedString primaryIndexName, Map<String, IndexAliasDefinition> aliases, IndexSettings settings, RootTypeMapping mapping, OperationSubmitter operationSubmitter) {
        CreateIndexWork work = this.getWorkFactory().createIndex(primaryIndexName).aliases(aliases).settings(settings).mapping(mapping).build();
        return this.execute(work, operationSubmitter);
    }

    public CompletableFuture<Boolean> createIndexIgnoreExisting(URLEncodedString primaryIndexName, Map<String, IndexAliasDefinition> aliases, IndexSettings settings, RootTypeMapping mapping, OperationSubmitter operationSubmitter) {
        CreateIndexWork work = this.getWorkFactory().createIndex(primaryIndexName).aliases(aliases).settings(settings).mapping(mapping).ignoreExisting().build();
        return this.execute(work, operationSubmitter).thenApply(CreateIndexResult.CREATED::equals);
    }

    public CompletableFuture<ExistingIndexMetadata> getCurrentIndexMetadata(IndexNames indexNames, OperationSubmitter operationSubmitter) {
        return this.getCurrentIndexMetadata(indexNames, false, operationSubmitter);
    }

    public CompletableFuture<ExistingIndexMetadata> getCurrentIndexMetadataOrNull(IndexNames indexNames, OperationSubmitter operationSubmitter) {
        return this.getCurrentIndexMetadata(indexNames, true, operationSubmitter);
    }

    private CompletableFuture<ExistingIndexMetadata> getCurrentIndexMetadata(IndexNames indexNames, boolean allowNull, OperationSubmitter operationSubmitter) {
        GetIndexMetadataWork work = this.getWorkFactory().getIndexMetadata().index(indexNames.write()).index(indexNames.read()).build();
        return ((CompletableFuture)this.execute(work, operationSubmitter).exceptionally(Futures.handler(e -> {
            throw ElasticsearchClientLog.INSTANCE.elasticsearchIndexMetadataRetrievalFailed(e.getMessage(), Throwables.expectException((Throwable)e));
        }))).thenApply(list -> {
            if (list.isEmpty()) {
                if (allowNull) {
                    return null;
                }
                throw ElasticsearchClientLog.INSTANCE.indexMissing(indexNames.write(), indexNames.read());
            }
            if (list.size() > 1) {
                throw ElasticsearchClientLog.INSTANCE.elasticsearchIndexNameAndAliasesMatchMultipleIndexes(indexNames.write(), indexNames.read(), list.stream().map(ExistingIndexMetadata::getPrimaryName).collect(Collectors.toSet()));
            }
            return (ExistingIndexMetadata)list.get(0);
        });
    }

    public CompletableFuture<?> updateAliases(URLEncodedString indexName, Map<String, IndexAliasDefinition> aliases, OperationSubmitter operationSubmitter) {
        PutIndexAliasesWork work = this.getWorkFactory().putIndexAliases(indexName, aliases).build();
        return this.execute(work, operationSubmitter).exceptionally(Futures.handler(e -> {
            throw ElasticsearchClientLog.INSTANCE.elasticsearchAliasUpdateFailed(indexName.original, e.getMessage(), Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> updateSettings(URLEncodedString indexName, IndexSettings settings, OperationSubmitter operationSubmitter) {
        PutIndexSettingsWork work = this.getWorkFactory().putIndexSettings(indexName, settings).build();
        return this.execute(work, operationSubmitter).exceptionally(Futures.handler(e -> {
            throw ElasticsearchClientLog.INSTANCE.elasticsearchSettingsUpdateFailed(indexName.original, e.getMessage(), Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> updateMapping(URLEncodedString indexName, RootTypeMapping mapping, OperationSubmitter operationSubmitter) {
        PutIndexMappingWork work = this.getWorkFactory().putIndexTypeMapping(indexName, mapping).build();
        return this.execute(work, operationSubmitter).exceptionally(Futures.handler(e -> {
            throw ElasticsearchClientLog.INSTANCE.elasticsearchMappingUpdateFailed(indexName.original, e.getMessage(), Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> waitForIndexStatus(IndexNames indexNames, ElasticsearchIndexLifecycleExecutionOptions executionOptions, OperationSubmitter operationSubmitter) {
        IndexStatus requiredIndexStatus = executionOptions.getRequiredStatus();
        if (requiredIndexStatus == null) {
            return CompletableFuture.completedFuture(null);
        }
        int requiredStatusTimeoutInMs = executionOptions.getRequiredStatusTimeoutInMs();
        URLEncodedString name = indexNames.write();
        WaitForIndexStatusWork work = this.getWorkFactory().waitForIndexStatus(name, requiredIndexStatus, requiredStatusTimeoutInMs).build();
        return this.execute(work, operationSubmitter).exceptionally(Futures.handler(e -> {
            throw ElasticsearchClientLog.INSTANCE.unexpectedIndexStatus(name, requiredIndexStatus.externalRepresentation(), requiredStatusTimeoutInMs, Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> dropIndexIfExisting(URLEncodedString indexName, OperationSubmitter operationSubmitter) {
        DropIndexWork work = this.getWorkFactory().dropIndex(indexName).ignoreIndexNotFound().build();
        return this.execute(work, operationSubmitter);
    }

    public CompletableFuture<?> closeIndex(URLEncodedString indexName, OperationSubmitter operationSubmitter) {
        CloseIndexWork work = this.getWorkFactory().closeIndex(indexName).build();
        return this.execute(work, operationSubmitter).thenRun(() -> ElasticsearchClientLog.INSTANCE.closedIndex(indexName));
    }

    public CompletableFuture<?> openIndex(URLEncodedString indexName, OperationSubmitter operationSubmitter) {
        OpenIndexWork work = this.getWorkFactory().openIndex(indexName).build();
        return this.execute(work, operationSubmitter).thenRun(() -> ElasticsearchClientLog.INSTANCE.openedIndex(indexName));
    }

    private ElasticsearchWorkFactory getWorkFactory() {
        return this.workFactory;
    }

    private <T> CompletableFuture<T> execute(NonBulkableWork<T> work, OperationSubmitter operationSubmitter) {
        return this.orchestrator.submit(work, operationSubmitter);
    }
}

