/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.dsl.predicate.LuceneSearchPredicateFactoryContext;
import org.hibernate.search.backend.lucene.search.dsl.predicate.impl.LuceneSearchPredicateFactoryContextImpl;
import org.hibernate.search.backend.lucene.search.dsl.projection.LuceneSearchProjectionFactoryContext;
import org.hibernate.search.backend.lucene.search.dsl.projection.impl.LuceneSearchProjectionFactoryContextImpl;
import org.hibernate.search.backend.lucene.search.dsl.sort.LuceneSearchSortContainerContext;
import org.hibernate.search.backend.lucene.search.dsl.sort.impl.LuceneSearchSortContainerContextImpl;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilderFactory;
import org.hibernate.search.backend.lucene.types.dsl.LuceneIndexFieldTypeFactoryContext;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactoryContext;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactoryContextExtension;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContextExtension;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContextExtension;
import org.hibernate.search.engine.search.dsl.sort.SearchSortContainerContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortContainerContextExtension;
import org.hibernate.search.engine.search.dsl.sort.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.engine.search.sort.spi.SearchSortBuilderFactory;
import org.hibernate.search.util.impl.common.LoggerFactory;

public final class LuceneExtension<R, O>
implements SearchPredicateFactoryContextExtension<LuceneSearchPredicateFactoryContext>,
SearchSortContainerContextExtension<LuceneSearchSortContainerContext>,
SearchProjectionFactoryContextExtension<LuceneSearchProjectionFactoryContext<R, O>, R, O>,
IndexFieldTypeFactoryContextExtension<LuceneIndexFieldTypeFactoryContext> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final LuceneExtension<Object, Object> INSTANCE = new LuceneExtension();

    public static <R, O> LuceneExtension<R, O> get() {
        return INSTANCE;
    }

    private LuceneExtension() {
    }

    public <C, B> Optional<LuceneSearchPredicateFactoryContext> extendOptional(SearchPredicateFactoryContext original, SearchPredicateBuilderFactory<C, B> factory) {
        if (factory instanceof LuceneSearchPredicateBuilderFactory) {
            return Optional.of(new LuceneSearchPredicateFactoryContextImpl(original, (LuceneSearchPredicateBuilderFactory)factory));
        }
        return Optional.empty();
    }

    public <C, B> Optional<LuceneSearchSortContainerContext> extendOptional(SearchSortContainerContext original, SearchSortBuilderFactory<C, B> factory, SearchSortDslContext<? super B> dslContext) {
        if (factory instanceof LuceneSearchSortBuilderFactory) {
            return Optional.of(this.extendUnsafe(original, (LuceneSearchSortBuilderFactory)factory, dslContext));
        }
        return Optional.empty();
    }

    public Optional<LuceneSearchProjectionFactoryContext<R, O>> extendOptional(SearchProjectionFactoryContext<R, O> original, SearchProjectionBuilderFactory factory) {
        if (factory instanceof LuceneSearchProjectionBuilderFactory) {
            return Optional.of(new LuceneSearchProjectionFactoryContextImpl<R, O>(original, (LuceneSearchProjectionBuilderFactory)factory));
        }
        return Optional.empty();
    }

    public LuceneIndexFieldTypeFactoryContext extendOrFail(IndexFieldTypeFactoryContext original) {
        if (original instanceof LuceneIndexFieldTypeFactoryContext) {
            return (LuceneIndexFieldTypeFactoryContext)original;
        }
        throw log.luceneExtensionOnUnknownType(original);
    }

    private <B> LuceneSearchSortContainerContext extendUnsafe(SearchSortContainerContext original, LuceneSearchSortBuilderFactory factory, SearchSortDslContext<? super B> dslContext) {
        return new LuceneSearchSortContainerContextImpl(original, factory, dslContext);
    }
}

