/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoaderHelper;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.util.impl.common.LoggerFactory;

final class HibernateSearchResourceLoader
implements ResourceLoader {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ClassResolver classResolver;
    private final ResourceResolver resourceResolver;

    HibernateSearchResourceLoader(ClassResolver classResolver, ResourceResolver resourceResolver) {
        this.classResolver = classResolver;
        this.resourceResolver = resourceResolver;
    }

    public InputStream openResource(String resource) throws IOException {
        InputStream inputStream = this.resourceResolver.locateResourceStream(resource);
        if (inputStream == null) {
            throw log.unableToLoadResource(resource);
        }
        return inputStream;
    }

    public <T> Class<? extends T> findClass(String className, Class<T> expectedType) {
        return ClassLoaderHelper.classForName(expectedType, (String)className, (String)HibernateSearchResourceLoader.describeComponent(className), (ClassResolver)this.classResolver);
    }

    public <T> T newInstance(String className, Class<T> expectedType) {
        return (T)ClassLoaderHelper.instanceFromName(expectedType, (String)className, (String)HibernateSearchResourceLoader.describeComponent(className), (ClassResolver)this.classResolver);
    }

    private static String describeComponent(String className) {
        return "Lucene Analyzer component " + className;
    }
}

