/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.hibernate.search.util.impl.common.CollectionHelper;

public final class ScopedAnalyzer
extends AnalyzerWrapper {
    private final Analyzer globalAnalyzer;
    private final Map<String, Analyzer> scopedAnalyzers;

    private ScopedAnalyzer(Analyzer globalAnalyzer, Map<String, Analyzer> scopedAnalyzers) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.globalAnalyzer = globalAnalyzer;
        this.scopedAnalyzers = CollectionHelper.toImmutableMap(scopedAnalyzers);
    }

    protected Analyzer getWrappedAnalyzer(String absoluteFieldPath) {
        Analyzer analyzer = this.scopedAnalyzers.get(absoluteFieldPath);
        if (analyzer == null) {
            return this.globalAnalyzer;
        }
        return analyzer;
    }

    public static class Builder {
        private final Analyzer globalAnalyzer;
        private final Map<String, Analyzer> scopedAnalyzers = new HashMap<String, Analyzer>();

        public Builder(Analyzer globalAnalyzer) {
            this.globalAnalyzer = globalAnalyzer;
        }

        public void setAnalyzer(String absoluteFieldPath, Analyzer analyzer) {
            this.scopedAnalyzers.put(absoluteFieldPath, analyzer);
        }

        public ScopedAnalyzer build() {
            return new ScopedAnalyzer(this.globalAnalyzer, this.scopedAnalyzers);
        }
    }
}

