/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalysisComponentDefinitionContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneCustomAnalysisDefinitionContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.DelegatingAnalysisDefinitionContainerContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalysisComponentBuilder;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

abstract class AbstractLuceneAnalysisComponentDefinitionContext<T>
extends DelegatingAnalysisDefinitionContainerContext
implements LuceneAnalysisComponentDefinitionContext,
LuceneAnalysisComponentBuilder<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneCustomAnalysisDefinitionContext parentContext;
    final Map<String, String> params = new LinkedHashMap<String, String>();

    AbstractLuceneAnalysisComponentDefinitionContext(LuceneCustomAnalysisDefinitionContext parentContext) {
        super(parentContext);
        this.parentContext = parentContext;
    }

    @Override
    public LuceneAnalysisComponentDefinitionContext param(String name, String value) {
        String previous = this.params.putIfAbsent(name, value);
        if (previous != null) {
            throw log.analysisComponentParameterConflict(name, previous, value);
        }
        return this;
    }

    @Override
    public LuceneAnalysisComponentDefinitionContext charFilter(Class<? extends CharFilterFactory> factory) {
        return this.parentContext.charFilter(factory);
    }

    @Override
    public LuceneAnalysisComponentDefinitionContext tokenFilter(Class<? extends TokenFilterFactory> factory) {
        return this.parentContext.tokenFilter(factory);
    }
}

