/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.analysis.impl.LuceneAnalysisComponentFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalysisDefinitionContainerContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalyzerDefinitionContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneCustomAnalyzerDefinitionContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneCustomNormalizerDefinitionContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneNormalizerDefinitionContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalysisComponentBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalyzerBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalyzerInstanceContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneCustomAnalyzerDefinitionContextImpl;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneCustomNormalizerDefinitionContextImpl;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneNormalizerInstanceContext;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionCollector;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionContributor;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class InitialLuceneAnalysisDefinitionContainerContext
implements LuceneAnalysisDefinitionContainerContext,
LuceneAnalysisDefinitionContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneAnalysisComponentFactory factory;
    private Map<String, LuceneAnalyzerBuilder> analyzers = new LinkedHashMap<String, LuceneAnalyzerBuilder>();
    private Map<String, LuceneAnalyzerBuilder> normalizers = new LinkedHashMap<String, LuceneAnalyzerBuilder>();

    public InitialLuceneAnalysisDefinitionContainerContext(LuceneAnalysisComponentFactory factory) {
        this.factory = factory;
    }

    @Override
    public LuceneAnalyzerDefinitionContext analyzer(final String name) {
        return new LuceneAnalyzerDefinitionContext(){

            @Override
            public LuceneCustomAnalyzerDefinitionContext custom() {
                LuceneCustomAnalyzerDefinitionContextImpl definition = new LuceneCustomAnalyzerDefinitionContextImpl(InitialLuceneAnalysisDefinitionContainerContext.this, name);
                InitialLuceneAnalysisDefinitionContainerContext.this.addAnalyzer(name, definition);
                return definition;
            }

            @Override
            public LuceneAnalysisDefinitionContainerContext instance(Analyzer instance) {
                LuceneAnalyzerInstanceContext definition = new LuceneAnalyzerInstanceContext(instance);
                InitialLuceneAnalysisDefinitionContainerContext.this.addAnalyzer(name, definition);
                return InitialLuceneAnalysisDefinitionContainerContext.this;
            }
        };
    }

    @Override
    public LuceneNormalizerDefinitionContext normalizer(final String name) {
        return new LuceneNormalizerDefinitionContext(){

            @Override
            public LuceneCustomNormalizerDefinitionContext custom() {
                LuceneCustomNormalizerDefinitionContextImpl definition = new LuceneCustomNormalizerDefinitionContextImpl(InitialLuceneAnalysisDefinitionContainerContext.this, name);
                InitialLuceneAnalysisDefinitionContainerContext.this.addNormalizer(name, definition);
                return definition;
            }

            @Override
            public LuceneAnalysisDefinitionContainerContext instance(Analyzer instance) {
                LuceneNormalizerInstanceContext definition = new LuceneNormalizerInstanceContext(name, instance);
                InitialLuceneAnalysisDefinitionContainerContext.this.addNormalizer(name, definition);
                return InitialLuceneAnalysisDefinitionContainerContext.this;
            }
        };
    }

    @Override
    public void contribute(LuceneAnalysisDefinitionCollector collector) {
        for (Map.Entry<String, LuceneAnalyzerBuilder> entry : this.analyzers.entrySet()) {
            collector.collectAnalyzer(entry.getKey(), entry.getValue().build(this.factory));
        }
        for (Map.Entry<String, LuceneAnalyzerBuilder> entry : this.normalizers.entrySet()) {
            collector.collectNormalizer(entry.getKey(), entry.getValue().build(this.factory));
        }
    }

    private void addAnalyzer(String name, LuceneAnalyzerBuilder definition) {
        LuceneAnalysisComponentBuilder existing = this.analyzers.putIfAbsent(name, definition);
        if (existing != null) {
            throw log.analyzerDefinitionNamingConflict(name);
        }
    }

    private void addNormalizer(String name, LuceneAnalyzerBuilder definition) {
        LuceneAnalysisComponentBuilder existing = this.normalizers.putIfAbsent(name, definition);
        if (existing != null) {
            throw log.normalizerDefinitionNamingConflict(name);
        }
    }
}

