/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.cfg;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

public enum MultiTenancyStrategyName {
    NONE("none"),
    DISCRIMINATOR("discriminator");

    private static final Log log;
    private final String externalRepresentation;

    private MultiTenancyStrategyName(String externalRepresentation) {
        this.externalRepresentation = externalRepresentation;
    }

    public static MultiTenancyStrategyName fromExternalRepresentation(String multiTenancyStrategy) {
        if (MultiTenancyStrategyName.NONE.externalRepresentation.equals(multiTenancyStrategy)) {
            return NONE;
        }
        if (MultiTenancyStrategyName.DISCRIMINATOR.externalRepresentation.equals(multiTenancyStrategy)) {
            return DISCRIMINATOR;
        }
        throw log.unknownMultiTenancyStrategyConfiguration(multiTenancyStrategy);
    }

    static {
        log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    }
}

