/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneFlattenedObjectDocumentBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneNestedObjectDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.util.impl.common.LoggerFactory;

public abstract class AbstractLuceneDocumentBuilder
implements LuceneDocumentBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final LuceneIndexSchemaObjectNode schemaNode;
    private List<LuceneFlattenedObjectDocumentBuilder> flattenedObjectDocumentBuilders;
    private List<LuceneNestedObjectDocumentBuilder> nestedObjectDocumentBuilders;

    protected AbstractLuceneDocumentBuilder(LuceneIndexSchemaObjectNode schemaNode) {
        this.schemaNode = schemaNode;
    }

    @Override
    public void addNestedObjectDocumentBuilder(LuceneNestedObjectDocumentBuilder nestedObjectDocumentBuilder) {
        if (this.nestedObjectDocumentBuilders == null) {
            this.nestedObjectDocumentBuilders = new ArrayList<LuceneNestedObjectDocumentBuilder>();
        }
        this.nestedObjectDocumentBuilders.add(nestedObjectDocumentBuilder);
    }

    @Override
    public void addFlattenedObjectDocumentBuilder(LuceneFlattenedObjectDocumentBuilder flattenedObjectDocumentBuilder) {
        if (this.flattenedObjectDocumentBuilders == null) {
            this.flattenedObjectDocumentBuilders = new ArrayList<LuceneFlattenedObjectDocumentBuilder>();
        }
        this.flattenedObjectDocumentBuilders.add(flattenedObjectDocumentBuilder);
    }

    @Override
    public void checkTreeConsistency(LuceneIndexSchemaObjectNode expectedParentNode) {
        if (!Objects.equals(expectedParentNode, this.schemaNode)) {
            throw log.invalidParentDocumentObjectState(expectedParentNode.getAbsolutePath(), this.schemaNode.getAbsolutePath());
        }
    }

    void contribute(String rootIndexName, MultiTenancyStrategy multiTenancyStrategy, String tenantId, String rootId, Document currentDocument, List<Document> nestedDocuments) {
        if (this.flattenedObjectDocumentBuilders != null) {
            for (LuceneFlattenedObjectDocumentBuilder flattenedObjectDocumentBuilder : this.flattenedObjectDocumentBuilders) {
                flattenedObjectDocumentBuilder.contribute(rootIndexName, multiTenancyStrategy, tenantId, rootId, currentDocument, nestedDocuments);
            }
        }
        if (this.nestedObjectDocumentBuilders != null) {
            for (LuceneNestedObjectDocumentBuilder nestedObjectDocumentBuilder : this.nestedObjectDocumentBuilders) {
                nestedObjectDocumentBuilder.contribute(rootIndexName, multiTenancyStrategy, tenantId, rootId, currentDocument, nestedDocuments);
            }
        }
    }
}

