/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.AbstractLuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;

class LuceneFlattenedObjectDocumentBuilder
extends AbstractLuceneDocumentBuilder {
    private final Set<IndexableField> fields = new HashSet<IndexableField>();

    LuceneFlattenedObjectDocumentBuilder(LuceneIndexSchemaObjectNode schemaNode) {
        super(schemaNode);
    }

    @Override
    public void addField(IndexableField field) {
        this.fields.add(field);
    }

    @Override
    void contribute(String rootIndexName, MultiTenancyStrategy multiTenancyStrategy, String tenantId, String rootId, Document currentDocument, List<Document> nestedDocuments) {
        for (IndexableField field : this.fields) {
            currentDocument.add(field);
        }
        super.contribute(rootIndexName, multiTenancyStrategy, tenantId, rootId, currentDocument, nestedDocuments);
    }
}

