/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldAccessor;

public class LuceneIndexFieldAccessor<F>
implements IndexFieldAccessor<F> {
    private final LuceneIndexSchemaFieldNode<F> schemaNode;

    public LuceneIndexFieldAccessor(LuceneIndexSchemaFieldNode<F> schemaNode) {
        this.schemaNode = schemaNode;
    }

    public void write(DocumentElement target, F value) {
        LuceneDocumentBuilder documentBuilder = (LuceneDocumentBuilder)target;
        documentBuilder.checkTreeConsistency(this.schemaNode.getParent());
        this.schemaNode.getCodec().encode(documentBuilder, this.schemaNode.getAbsoluteFieldPath(), value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[schemaNode=" + this.schemaNode + "]";
    }
}

