/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneFlattenedObjectDocumentBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneNestedObjectDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexObjectFieldAccessor;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;

public class LuceneIndexObjectFieldAccessor
implements IndexObjectFieldAccessor {
    private final LuceneIndexSchemaObjectNode schemaNode;
    private final ObjectFieldStorage storage;

    public LuceneIndexObjectFieldAccessor(LuceneIndexSchemaObjectNode schemaNode, ObjectFieldStorage storage) {
        this.schemaNode = schemaNode;
        this.storage = storage;
    }

    public DocumentElement add(DocumentElement target) {
        LuceneDocumentBuilder currentDocumentBuilder = (LuceneDocumentBuilder)target;
        currentDocumentBuilder.checkTreeConsistency(this.schemaNode.getParent());
        switch (this.storage) {
            case NESTED: {
                LuceneNestedObjectDocumentBuilder nestedDocumentBuilder = new LuceneNestedObjectDocumentBuilder(this.schemaNode);
                currentDocumentBuilder.addNestedObjectDocumentBuilder(nestedDocumentBuilder);
                return nestedDocumentBuilder;
            }
        }
        LuceneFlattenedObjectDocumentBuilder flattenedDocumentBuilder = new LuceneFlattenedObjectDocumentBuilder(this.schemaNode);
        currentDocumentBuilder.addFlattenedObjectDocumentBuilder(flattenedDocumentBuilder);
        return flattenedDocumentBuilder;
    }

    public void addMissing(DocumentElement target) {
    }
}

