/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import org.hibernate.search.backend.lucene.document.model.dsl.impl.AbstractLuceneIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeContributor;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;
import org.hibernate.search.engine.backend.document.IndexFieldAccessor;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldTerminalContext;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.spi.IndexSchemaFieldDefinitionHelper;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.EventContext;

class LuceneIndexSchemaFieldNodeBuilder<F>
implements IndexSchemaFieldTerminalContext<IndexFieldAccessor<F>>,
LuceneIndexSchemaNodeContributor,
IndexSchemaBuildContext {
    private final AbstractLuceneIndexSchemaObjectNodeBuilder parent;
    private final String relativeFieldName;
    private final String absoluteFieldPath;
    private final LuceneIndexFieldType<F> type;
    private final IndexSchemaFieldDefinitionHelper<F> helper;

    LuceneIndexSchemaFieldNodeBuilder(AbstractLuceneIndexSchemaObjectNodeBuilder parent, String relativeFieldName, LuceneIndexFieldType<F> type) {
        this.parent = parent;
        this.relativeFieldName = relativeFieldName;
        this.absoluteFieldPath = LuceneFields.compose(parent.getAbsolutePath(), relativeFieldName);
        this.type = type;
        this.helper = new IndexSchemaFieldDefinitionHelper((IndexSchemaBuildContext)this);
    }

    public EventContext getEventContext() {
        return this.parent.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public IndexFieldAccessor<F> createAccessor() {
        return this.helper.createAccessor();
    }

    @Override
    public void contribute(LuceneIndexSchemaNodeCollector collector, LuceneIndexSchemaObjectNode parentNode) {
        IndexFieldAccessor<F> accessor = this.type.addField(collector, parentNode, this.relativeFieldName);
        this.helper.initialize(accessor);
    }
}

