/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import org.hibernate.search.backend.lucene.document.impl.LuceneIndexObjectFieldAccessor;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.AbstractLuceneIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeContributor;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;
import org.hibernate.search.engine.backend.document.IndexObjectFieldAccessor;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.spi.IndexSchemaObjectFieldDefinitionHelper;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.EventContext;

class LuceneIndexSchemaObjectFieldNodeBuilder
extends AbstractLuceneIndexSchemaObjectNodeBuilder
implements IndexSchemaObjectFieldNodeBuilder,
LuceneIndexSchemaNodeContributor {
    private final AbstractLuceneIndexSchemaObjectNodeBuilder parent;
    private final String absoluteFieldPath;
    private final ObjectFieldStorage storage;
    private final IndexSchemaObjectFieldDefinitionHelper helper;

    LuceneIndexSchemaObjectFieldNodeBuilder(AbstractLuceneIndexSchemaObjectNodeBuilder parent, String relativeFieldName, ObjectFieldStorage storage) {
        this.parent = parent;
        this.absoluteFieldPath = LuceneFields.compose(parent.getAbsolutePath(), relativeFieldName);
        this.storage = storage;
        this.helper = new IndexSchemaObjectFieldDefinitionHelper((IndexSchemaBuildContext)this);
    }

    public EventContext getEventContext() {
        return this.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public IndexObjectFieldAccessor createAccessor() {
        return this.helper.createAccessor();
    }

    @Override
    public void contribute(LuceneIndexSchemaNodeCollector collector, LuceneIndexSchemaObjectNode parentNode) {
        LuceneIndexSchemaObjectNode node = new LuceneIndexSchemaObjectNode(parentNode, this.absoluteFieldPath, this.storage);
        collector.collectObjectNode(this.absoluteFieldPath, node);
        this.helper.initialize((IndexObjectFieldAccessor)new LuceneIndexObjectFieldAccessor(node, this.storage));
        this.contributeChildren(node, collector);
    }

    @Override
    public LuceneIndexSchemaRootNodeBuilder getRootNodeBuilder() {
        return this.parent.getRootNodeBuilder();
    }

    @Override
    String getAbsolutePath() {
        return this.absoluteFieldPath;
    }
}

