/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.hibernate.search.backend.lucene.index.impl.DirectoryProvider;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.impl.common.LoggerFactory;

class MMapDirectoryProvider
implements DirectoryProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EventContext backendContext;
    private final Path rootDirectory;

    MMapDirectoryProvider(EventContext backendContext, Path rootDirectory) {
        this.backendContext = backendContext;
        this.rootDirectory = rootDirectory;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[rootDirectory=" + this.rootDirectory + "]";
    }

    @Override
    public Directory createDirectory(String indexName) throws IOException {
        Path directoryPath = this.rootDirectory.resolve(indexName);
        this.initializeIndexDirectory(directoryPath);
        return new MMapDirectory(directoryPath);
    }

    private void initializeIndexDirectory(Path indexDirectory) {
        if (Files.exists(indexDirectory, new LinkOption[0])) {
            if (!Files.isDirectory(indexDirectory, new LinkOption[0]) || !Files.isWritable(indexDirectory)) {
                throw log.localDirectoryIndexRootDirectoryNotWritableDirectory(indexDirectory, this.backendContext);
            }
        } else {
            try {
                Files.createDirectories(indexDirectory, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw log.unableToCreateIndexRootDirectoryForLocalDirectoryBackend(indexDirectory, this.backendContext, e);
            }
        }
    }
}

