/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.index.impl.DirectoryProvider;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexDocumentWorkExecutor;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexWorkExecutor;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexWorkPlan;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneIndexWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.index.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.backend.index.spi.IndexWorkExecutor;
import org.hibernate.search.engine.backend.index.spi.IndexWorkPlan;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.util.EventContext;

public class IndexingBackendContext {
    private final EventContext eventContext;
    private final DirectoryProvider directoryProvider;
    private final LuceneWorkFactory workFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;

    public IndexingBackendContext(EventContext eventContext, DirectoryProvider directoryProvider, LuceneWorkFactory workFactory, MultiTenancyStrategy multiTenancyStrategy) {
        this.eventContext = eventContext;
        this.directoryProvider = directoryProvider;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.workFactory = workFactory;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    EventContext getEventContext() {
        return this.eventContext;
    }

    Directory createDirectory(String indexName) throws IOException {
        return this.directoryProvider.createDirectory(indexName);
    }

    IndexWorkPlan<LuceneRootDocumentBuilder> createWorkPlan(LuceneIndexWorkOrchestrator orchestrator, String indexName, SessionContextImplementor sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new LuceneIndexWorkPlan(this.workFactory, this.multiTenancyStrategy, orchestrator, indexName, sessionContext);
    }

    IndexDocumentWorkExecutor<LuceneRootDocumentBuilder> createDocumentWorkExecutor(LuceneIndexWorkOrchestrator orchestrator, String indexName, SessionContextImplementor sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new LuceneIndexDocumentWorkExecutor(this.workFactory, this.multiTenancyStrategy, orchestrator, indexName, sessionContext);
    }

    public IndexWorkExecutor createWorkExecutor(LuceneIndexWorkOrchestrator orchestrator, String indexName) {
        return new LuceneIndexWorkExecutor(this.workFactory, this.multiTenancyStrategy, orchestrator, indexName, this.eventContext);
    }
}

