/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexManagerImpl;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.search.util.impl.common.SuppressingCloser;

public class LuceneIndexManagerBuilder
implements IndexManagerBuilder<LuceneRootDocumentBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexingBackendContext indexingBackendContext;
    private final SearchBackendContext searchBackendContext;
    private final String indexName;
    private final LuceneIndexSchemaRootNodeBuilder schemaRootNodeBuilder;

    public LuceneIndexManagerBuilder(IndexingBackendContext indexingBackendContext, SearchBackendContext searchBackendContext, String indexName, LuceneIndexSchemaRootNodeBuilder schemaRootNodeBuilder) {
        this.indexingBackendContext = indexingBackendContext;
        this.searchBackendContext = searchBackendContext;
        this.indexName = indexName;
        this.schemaRootNodeBuilder = schemaRootNodeBuilder;
    }

    public void closeOnFailure() {
    }

    public IndexSchemaRootNodeBuilder getSchemaRootNodeBuilder() {
        return this.schemaRootNodeBuilder;
    }

    public LuceneIndexManagerImpl build() {
        LuceneIndexModel model = null;
        IndexWriter indexWriter = null;
        try {
            model = this.schemaRootNodeBuilder.build(this.indexName);
            indexWriter = this.createIndexWriter(model);
            return new LuceneIndexManagerImpl(this.indexingBackendContext, this.searchBackendContext, this.indexName, model, indexWriter);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)model).push((AutoCloseable)indexWriter);
            throw e;
        }
    }

    private IndexWriter createIndexWriter(LuceneIndexModel model) {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)model.getScopedAnalyzer());
        try {
            Directory directory = this.indexingBackendContext.createDirectory(this.indexName);
            try {
                return new IndexWriter(directory, indexWriterConfig);
            }
            catch (RuntimeException e) {
                new SuppressingCloser((Throwable)e).push((AutoCloseable)directory);
                throw e;
            }
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToCreateIndexWriter(this.getEventContext(), e);
        }
    }

    private EventContext getEventContext() {
        return this.indexingBackendContext.getEventContext().append(EventContexts.fromIndexName((String)this.indexName));
    }
}

