/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexManagerImpl;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchTargetModel;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchTargetContext;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.engine.backend.index.spi.IndexSearchTargetContextBuilder;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.search.dsl.spi.SearchTargetContext;
import org.hibernate.search.util.impl.common.LoggerFactory;

class LuceneIndexSearchTargetContextBuilder
implements IndexSearchTargetContextBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SearchBackendContext searchBackendContext;
    private final MappingContextImplementor mappingContext;
    private final Set<LuceneIndexManagerImpl> indexManagers = new LinkedHashSet<LuceneIndexManagerImpl>();

    LuceneIndexSearchTargetContextBuilder(SearchBackendContext searchBackendContext, MappingContextImplementor mappingContext, LuceneIndexManagerImpl indexManager) {
        this.searchBackendContext = searchBackendContext;
        this.mappingContext = mappingContext;
        this.indexManagers.add(indexManager);
    }

    void add(SearchBackendContext searchBackendContext, LuceneIndexManagerImpl indexManager) {
        if (!this.searchBackendContext.equals(searchBackendContext)) {
            throw log.cannotMixLuceneSearchTargetWithOtherBackend(this, indexManager, searchBackendContext.getEventContext());
        }
        this.indexManagers.add(indexManager);
    }

    public SearchTargetContext<?> build() {
        Set indexModels = this.indexManagers.stream().map(LuceneIndexManagerImpl::getModel).collect(Collectors.toCollection(LinkedHashSet::new));
        Set readerProviders = this.indexManagers.stream().map(LuceneIndexManagerImpl::getReaderProvider).collect(Collectors.toCollection(LinkedHashSet::new));
        LuceneSearchTargetModel searchTargetModel = new LuceneSearchTargetModel(indexModels, readerProviders);
        return new LuceneSearchTargetContext(this.searchBackendContext, this.mappingContext, searchTargetModel);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "searchBackendContext=" + this.searchBackendContext + ", indexManagers=" + this.indexManagers + "]";
    }
}

