/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneIndexWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneStubIndexWorkExecutionContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneIndexWork;
import org.hibernate.search.util.impl.common.Futures;

public class LuceneStubIndexWorkOrchestrator
implements LuceneIndexWorkOrchestrator {
    private final LuceneStubIndexWorkExecutionContext context;
    private CompletableFuture<?> latestFuture = CompletableFuture.completedFuture(null);

    public LuceneStubIndexWorkOrchestrator(IndexWriter indexWriter) {
        this.context = new LuceneStubIndexWorkExecutionContext(indexWriter);
    }

    @Override
    public void close() {
        this.latestFuture.join();
    }

    @Override
    public synchronized <T> CompletableFuture<T> submit(LuceneIndexWork<T> work) {
        CompletionStage future = this.latestFuture.thenCompose(Futures.safeComposer(ignored -> work.execute(this.context)));
        this.latestFuture = ((CompletableFuture)future).exceptionally(ignore -> null);
        return future;
    }

    @Override
    public synchronized CompletableFuture<?> submit(List<LuceneIndexWork<?>> works) {
        CompletionStage<Object> future = this.latestFuture;
        for (LuceneIndexWork<?> work : works) {
            future = future.thenCompose(Futures.safeComposer(ignored -> work.execute(this.context)));
        }
        this.latestFuture = future.exceptionally(ignore -> null);
        return future;
    }
}

