/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.hibernate.search.backend.lucene.search.extraction.impl.DistanceCollector;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.engine.spatial.GeoPoint;

public class LuceneCollectorsBuilder {
    private Sort sort;
    private int maxDocs;
    private TopDocsCollector<?> topDocsCollector;
    private TotalHitCountCollector totalHitCountCollector;
    private List<Collector> luceneCollectors = new ArrayList<Collector>();

    public LuceneCollectorsBuilder(Sort sort, int maxDocs) {
        this.sort = sort;
        this.maxDocs = maxDocs;
        this.totalHitCountCollector = new TotalHitCountCollector();
        this.luceneCollectors.add((Collector)this.totalHitCountCollector);
    }

    public void requireTopDocsCollector() {
        if (this.maxDocs > 0) {
            this.topDocsCollector = LuceneCollectorsBuilder.createTopDocsCollector(this.sort, this.maxDocs);
            this.luceneCollectors.add((Collector)this.topDocsCollector);
        }
    }

    public void addCollector(Collector collector) {
        this.luceneCollectors.add(collector);
    }

    public DistanceCollector addDistanceCollector(String absoluteFieldPath, GeoPoint center) {
        DistanceCollector distanceCollector = new DistanceCollector(absoluteFieldPath, center, this.maxDocs);
        this.luceneCollectors.add(distanceCollector);
        return distanceCollector;
    }

    public LuceneCollectors build() {
        Collector compositeCollector = this.luceneCollectors.size() == 1 ? this.luceneCollectors.get(0) : MultiCollector.wrap(this.luceneCollectors);
        return new LuceneCollectors(this.topDocsCollector, this.totalHitCountCollector, compositeCollector);
    }

    private static TopDocsCollector<?> createTopDocsCollector(Sort sort, int maxDocs) {
        Object topDocsCollector = sort == null ? TopScoreDocCollector.create((int)maxDocs) : TopFieldCollector.create((Sort)sort, (int)maxDocs, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        return topDocsCollector;
    }
}

