/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateCollector;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;

public class LuceneSearchQueryElementCollector
implements LuceneSearchPredicateCollector,
LuceneSearchSortCollector {
    private Query luceneQueryPredicate;
    private List<SortField> sortFields;

    @Override
    public void collectPredicate(Query luceneQuery) {
        this.luceneQueryPredicate = luceneQuery;
    }

    @Override
    public void collectSortField(SortField sortField) {
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(5);
        }
        this.sortFields.add(sortField);
    }

    @Override
    public void collectSortFields(SortField[] sortFields) {
        if (sortFields == null || sortFields.length == 0) {
            return;
        }
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(sortFields.length);
        }
        Collections.addAll(this.sortFields, sortFields);
    }

    public Query toLuceneQueryPredicate() {
        return this.luceneQueryPredicate;
    }

    public List<SortField> toLuceneSortFields() {
        return this.sortFields;
    }

    public Sort toLuceneSort() {
        if (this.sortFields == null || this.sortFields.isEmpty()) {
            return null;
        }
        return new Sort(this.sortFields.toArray(new SortField[this.sortFields.size()]));
    }
}

