/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.impl;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.index.spi.ReaderProvider;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class LuceneSearchTargetModel {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Set<LuceneIndexModel> indexModels;
    private final Set<String> indexNames;
    private final Set<ReaderProvider> readerProviders;

    public LuceneSearchTargetModel(Set<LuceneIndexModel> indexModels, Set<ReaderProvider> readerProviders) {
        this.indexModels = indexModels;
        this.indexNames = indexModels.stream().map(LuceneIndexModel::getIndexName).collect(Collectors.toSet());
        this.readerProviders = readerProviders;
    }

    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public EventContext getIndexesEventContext() {
        return EventContexts.fromIndexNames(this.indexNames);
    }

    public Set<LuceneIndexModel> getIndexModels() {
        return this.indexModels;
    }

    public Set<ReaderProvider> getReaderProviders() {
        return this.readerProviders;
    }

    public ToDocumentIdentifierValueConverter<?> getIdDslConverter() {
        Iterator<LuceneIndexModel> iterator = this.indexModels.iterator();
        LuceneIndexModel indexModelForSelectedIdConverter = iterator.next();
        ToDocumentIdentifierValueConverter<?> selectedIdConverter = indexModelForSelectedIdConverter.getIdDslConverter();
        while (iterator.hasNext()) {
            LuceneIndexModel indexModel = iterator.next();
            ToDocumentIdentifierValueConverter<?> idConverter = indexModel.getIdDslConverter();
            if (selectedIdConverter.isCompatibleWith(idConverter)) continue;
            throw log.conflictingIdentifierTypesForPredicate(selectedIdConverter, idConverter, EventContexts.fromIndexNames((String[])new String[]{indexModelForSelectedIdConverter.getIndexName(), indexModel.getIndexName()}));
        }
        return selectedIdConverter;
    }

    public <T> T getSchemaNodeComponent(String absoluteFieldPath, IndexSchemaFieldNodeComponentRetrievalStrategy<T> componentRetrievalStrategy) {
        LuceneIndexModel indexModelForSelectedSchemaNode = null;
        LuceneIndexSchemaFieldNode<?> selectedSchemaNode = null;
        Object selectedComponent = null;
        for (LuceneIndexModel indexModel : this.indexModels) {
            LuceneIndexSchemaFieldNode<?> schemaNode = indexModel.getFieldNode(absoluteFieldPath);
            if (schemaNode == null) continue;
            T component = componentRetrievalStrategy.extractComponent(schemaNode);
            if (selectedSchemaNode == null) {
                selectedSchemaNode = schemaNode;
                indexModelForSelectedSchemaNode = indexModel;
                selectedComponent = component;
                continue;
            }
            if (componentRetrievalStrategy.areCompatible(selectedComponent, component)) continue;
            throw componentRetrievalStrategy.createCompatibilityException(absoluteFieldPath, selectedComponent, component, EventContexts.fromIndexNames((String[])new String[]{indexModelForSelectedSchemaNode.getIndexName(), indexModel.getIndexName()}));
        }
        if (selectedSchemaNode == null) {
            throw log.unknownFieldForSearch(absoluteFieldPath, this.getIndexesEventContext());
        }
        return selectedComponent;
    }

    public void checkNestedField(String absoluteFieldPath) {
        LuceneIndexSchemaFieldNode<?> schemaNode;
        boolean found = false;
        for (LuceneIndexModel indexModel : this.indexModels) {
            schemaNode = indexModel.getObjectNode(absoluteFieldPath);
            if (schemaNode == null) continue;
            found = true;
            if (ObjectFieldStorage.NESTED.equals((Object)((LuceneIndexSchemaObjectNode)((Object)schemaNode)).getStorage())) continue;
            throw log.nonNestedFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
        }
        if (!found) {
            for (LuceneIndexModel indexModel : this.indexModels) {
                schemaNode = indexModel.getFieldNode(absoluteFieldPath);
                if (schemaNode == null) continue;
                throw log.nonObjectFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
            }
            throw log.unknownFieldForSearch(absoluteFieldPath, this.getIndexesEventContext());
        }
    }
}

