/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.util.impl.common.LoggerFactory;

public abstract class AbstractLuceneStandardMatchPredicateBuilder<F, E, C extends LuceneStandardFieldCodec<F, E>>
extends AbstractLuceneSearchPredicateBuilder
implements MatchPredicateBuilder<LuceneSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearchContext searchContext;
    protected final String absoluteFieldPath;
    private final ToDocumentFieldValueConverter<?, ? extends F> converter;
    protected final C codec;
    protected E value;

    protected AbstractLuceneStandardMatchPredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> converter, C codec) {
        this.searchContext = searchContext;
        this.absoluteFieldPath = absoluteFieldPath;
        this.converter = converter;
        this.codec = codec;
    }

    public void value(Object value) {
        try {
            Object converted = this.converter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
            this.value = this.codec.encode((Object)converted);
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }
}

