/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;

public class LuceneMatchIdPredicateBuilder
extends AbstractLuceneSearchPredicateBuilder
implements MatchIdPredicateBuilder<LuceneSearchPredicateBuilder> {
    private List<String> values = new ArrayList<String>();
    private final LuceneSearchContext searchContext;
    private final ToDocumentIdentifierValueConverter<?> idDslConverter;

    public LuceneMatchIdPredicateBuilder(LuceneSearchContext searchContext, ToDocumentIdentifierValueConverter<?> idDslConverter) {
        this.searchContext = searchContext;
        this.idDslConverter = idDslConverter;
    }

    public void value(Object value) {
        ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext = this.searchContext.getToDocumentIdentifierValueConvertContext();
        this.values.add(this.idDslConverter.convertUnknown(value, toDocumentIdentifierValueConvertContext));
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (String value : this.values) {
            builder.add((Query)this.termQuery(value), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    private TermQuery termQuery(String value) {
        return new TermQuery(new Term(LuceneFields.idFieldName(), value));
    }
}

