/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchTargetModel;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneBooleanJunctionPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneMatchAllPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneMatchIdPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneNestedPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateCollector;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneUserProvidedLuceneQueryPredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.BooleanJunctionPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchAllPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class LuceneSearchPredicateBuilderFactoryImpl
implements LuceneSearchPredicateBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final PredicateBuilderFactoryRetrievalStrategy PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY = new PredicateBuilderFactoryRetrievalStrategy();
    private final LuceneSearchContext searchContext;
    private final LuceneSearchTargetModel searchTargetModel;

    public LuceneSearchPredicateBuilderFactoryImpl(LuceneSearchContext searchContext, LuceneSearchTargetModel searchTargetModel) {
        this.searchContext = searchContext;
        this.searchTargetModel = searchTargetModel;
    }

    public SearchPredicate toSearchPredicate(LuceneSearchPredicateBuilder builder) {
        return new LuceneSearchPredicate(builder);
    }

    public LuceneSearchPredicateBuilder toImplementation(SearchPredicate predicate) {
        if (!(predicate instanceof LuceneSearchPredicate)) {
            throw log.cannotMixLuceneSearchQueryWithOtherPredicates(predicate);
        }
        return (LuceneSearchPredicate)predicate;
    }

    public void contribute(LuceneSearchPredicateCollector collector, LuceneSearchPredicateBuilder builder) {
        collector.collectPredicate(builder.build(LuceneSearchPredicateContext.root()));
    }

    public MatchAllPredicateBuilder<LuceneSearchPredicateBuilder> matchAll() {
        return new LuceneMatchAllPredicateBuilder();
    }

    public MatchIdPredicateBuilder<LuceneSearchPredicateBuilder> id() {
        return new LuceneMatchIdPredicateBuilder(this.searchContext, this.searchTargetModel.getIdDslConverter());
    }

    public BooleanJunctionPredicateBuilder<LuceneSearchPredicateBuilder> bool() {
        return new LuceneBooleanJunctionPredicateBuilder();
    }

    public MatchPredicateBuilder<LuceneSearchPredicateBuilder> match(String absoluteFieldPath) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createMatchPredicateBuilder(this.searchContext, absoluteFieldPath);
    }

    public RangePredicateBuilder<LuceneSearchPredicateBuilder> range(String absoluteFieldPath) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createRangePredicateBuilder(this.searchContext, absoluteFieldPath);
    }

    public SpatialWithinCirclePredicateBuilder<LuceneSearchPredicateBuilder> spatialWithinCircle(String absoluteFieldPath) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createSpatialWithinCirclePredicateBuilder(absoluteFieldPath);
    }

    public SpatialWithinPolygonPredicateBuilder<LuceneSearchPredicateBuilder> spatialWithinPolygon(String absoluteFieldPath) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createSpatialWithinPolygonPredicateBuilder(absoluteFieldPath);
    }

    public SpatialWithinBoundingBoxPredicateBuilder<LuceneSearchPredicateBuilder> spatialWithinBoundingBox(String absoluteFieldPath) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createSpatialWithinBoundingBoxPredicateBuilder(absoluteFieldPath);
    }

    public NestedPredicateBuilder<LuceneSearchPredicateBuilder> nested(String absoluteFieldPath) {
        this.searchTargetModel.checkNestedField(absoluteFieldPath);
        return new LuceneNestedPredicateBuilder(absoluteFieldPath);
    }

    @Override
    public LuceneSearchPredicateBuilder fromLuceneQuery(Query query) {
        return new LuceneUserProvidedLuceneQueryPredicateBuilder(query);
    }

    private static class PredicateBuilderFactoryRetrievalStrategy
    implements IndexSchemaFieldNodeComponentRetrievalStrategy<LuceneFieldPredicateBuilderFactory> {
        private PredicateBuilderFactoryRetrievalStrategy() {
        }

        @Override
        public LuceneFieldPredicateBuilderFactory extractComponent(LuceneIndexSchemaFieldNode<?> schemaNode) {
            return schemaNode.getPredicateBuilderFactory();
        }

        @Override
        public boolean areCompatible(LuceneFieldPredicateBuilderFactory component1, LuceneFieldPredicateBuilderFactory component2) {
            return component1.isDslCompatibleWith(component2);
        }

        @Override
        public SearchException createCompatibilityException(String absoluteFieldPath, LuceneFieldPredicateBuilderFactory component1, LuceneFieldPredicateBuilderFactory component2, EventContext context) {
            return log.conflictingFieldTypesForPredicate(absoluteFieldPath, component1, component2, context);
        }
    }
}

