/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;

public class LuceneCompositeListProjection<T>
implements LuceneCompositeProjection<List<Object>, T> {
    private final Function<List<?>, T> transformer;
    private final List<LuceneSearchProjection<?, ?>> children;

    public LuceneCompositeListProjection(Function<List<?>, T> transformer, List<LuceneSearchProjection<?, ?>> children) {
        this.transformer = transformer;
        this.children = children;
    }

    @Override
    public void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        for (LuceneSearchProjection<?, ?> child : this.children) {
            child.contributeCollectors(luceneCollectorBuilder);
        }
    }

    @Override
    public void contributeFields(LuceneDocumentStoredFieldVisitorBuilder builder) {
        for (LuceneSearchProjection<?, ?> child : this.children) {
            child.contributeFields(builder);
        }
    }

    @Override
    public List<Object> extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        ArrayList<Object> extractedData = new ArrayList<Object>(this.children.size());
        for (LuceneSearchProjection<?, ?> child : this.children) {
            extractedData.add(child.extract(mapper, documentResult, context));
        }
        return extractedData;
    }

    @Override
    public T transform(LoadingResult<?> loadingResult, List<Object> extractedData, SearchProjectionTransformContext context) {
        for (int i = 0; i < extractedData.size(); ++i) {
            extractedData.set(i, LuceneSearchProjection.transformUnsafe(this.children.get(i), loadingResult, extractedData.get(i), context));
        }
        return this.transformer.apply(extractedData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("children=").append(this.children).append("]");
        return sb.toString();
    }
}

