/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import org.hibernate.search.backend.lucene.search.extraction.impl.DocumentReferenceExtractorHelper;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;

public class LuceneObjectProjection<O>
implements LuceneSearchProjection<Object, O> {
    private static final LuceneObjectProjection INSTANCE = new LuceneObjectProjection();

    public static <T> LuceneObjectProjection<T> get() {
        return INSTANCE;
    }

    private LuceneObjectProjection() {
    }

    @Override
    public void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        DocumentReferenceExtractorHelper.contributeCollectors(luceneCollectorBuilder);
    }

    @Override
    public void contributeFields(LuceneDocumentStoredFieldVisitorBuilder builder) {
        DocumentReferenceExtractorHelper.contributeFields(builder);
    }

    @Override
    public Object extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        return mapper.planLoading(DocumentReferenceExtractorHelper.extractDocumentReference(documentResult));
    }

    @Override
    public O transform(LoadingResult<?> loadingResult, Object extractedData, SearchProjectionTransformContext context) {
        return (O)loadingResult.getLoaded(extractedData);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

